/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigEntityFactory;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigSolution;
import org.kie.kogito.explainability.model.PredictionProvider;

class LimeConfigEntityFactoryTest {
    LimeConfigEntityFactoryTest() {
    }

    @Test
    void testEmptySolutionConversion() {
        LimeConfigSolution solution = new LimeConfigSolution();
        LimeConfig limeConfig = LimeConfigEntityFactory.toLimeConfig((LimeConfigSolution)solution);
        Assertions.assertThat((Object)limeConfig).isNotNull();
    }

    @Test
    void testConversion() {
        PredictionProvider model = TestUtils.getDummyTextClassifier();
        LimeConfig config = new LimeConfig();
        List predictions = Collections.emptyList();
        List entities = Collections.emptyList();
        LimeConfigSolution solution = new LimeConfigSolution(config, predictions, entities, model);
        LimeConfig limeConfig = LimeConfigEntityFactory.toLimeConfig((LimeConfigSolution)solution);
        Assertions.assertThat((Object)limeConfig).isNotNull();
    }

    @Test
    void testWeightingEntities() {
        List entities = LimeConfigEntityFactory.createWeightingEntities((LimeConfig)new LimeConfig());
        ((ListAssert)Assertions.assertThat((List)entities).isNotNull()).hasSize(1);
    }

    @Test
    void testSamplingEntities() {
        List entities = LimeConfigEntityFactory.createSamplingEntities((LimeConfig)new LimeConfig());
        ((ListAssert)Assertions.assertThat((List)entities).isNotNull()).hasSize(4);
    }

    @Test
    void testEncodingEntities() {
        List entities = LimeConfigEntityFactory.createEncodingEntities((LimeConfig)new LimeConfig());
        ((ListAssert)Assertions.assertThat((List)entities).isNotNull()).hasSize(2);
    }

    @Test
    void testProximityEntities() {
        List entities = LimeConfigEntityFactory.createProximityEntities((LimeConfig)new LimeConfig());
        ((ListAssert)Assertions.assertThat((List)entities).isNotNull()).hasSize(4);
    }
}

