/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.local.lime.optim.RecordingLimeExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.mockito.Mockito;

class RecordingLimeExplainerTest {
    RecordingLimeExplainerTest() {
    }

    @Test
    void testRecordedPredictions() {
        RecordingLimeExplainer recordingLimeExplainer = new RecordingLimeExplainer(10);
        ArrayList<Prediction> allPredictions = new ArrayList<Prediction>();
        PredictionProvider model = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        for (int i = 0; i < 15; ++i) {
            Prediction prediction = (Prediction)Mockito.mock(Prediction.class);
            allPredictions.add(prediction);
            try {
                recordingLimeExplainer.explainAsync(prediction, model).get(5L, Config.DEFAULT_ASYNC_TIMEUNIT);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Assertions.assertThat(allPredictions).hasSize(15);
        List recordedPredictions = recordingLimeExplainer.getRecordedPredictions();
        Assertions.assertThat((List)recordedPredictions).hasSize(10);
        Assertions.assertThat(allPredictions.subList(5, 15)).isEqualTo((Object)recordedPredictions);
    }

    @Test
    void testParallel() throws InterruptedException, ExecutionException, TimeoutException {
        int capacity = 10;
        RecordingLimeExplainer recordingLimeExplainer = new RecordingLimeExplainer(capacity);
        PredictionProvider model = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        Callable<Object> callable = () -> {
            for (int i = 0; i < 10000; ++i) {
                Prediction prediction = (Prediction)Mockito.mock(Prediction.class);
                try {
                    recordingLimeExplainer.explainAsync(prediction, model).get(5L, Config.DEFAULT_ASYNC_TIMEUNIT);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        };
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (int i = 0; i < 4; ++i) {
            futures.add(executorService.submit(callable));
        }
        for (Future future : futures) {
            future.get(1L, TimeUnit.MINUTES);
        }
        Assertions.assertThat((int)recordingLimeExplainer.getRecordedPredictions().size()).isEqualTo(capacity);
    }

    @Test
    void testQueue() {
        String[] strings;
        RecordingLimeExplainer.FixedSizeConcurrentLinkedDeque queue = new RecordingLimeExplainer.FixedSizeConcurrentLinkedDeque(5);
        for (String s : strings = "a b c d e f g f".split(" ")) {
            queue.offer((Object)s);
        }
        Assertions.assertThat((Collection)queue).containsExactly((Object[])"c d e f g".split(" "));
    }
}

