/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.GenericFeatureDistribution;
import org.kie.kogito.explainability.model.NumericFeatureDistribution;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

class NumericFeatureDistributionTest {
    NumericFeatureDistributionTest() {
    }

    @Test
    void testNumericFeatureDistributionSampling() {
        Feature feature = TestUtils.getMockedNumericFeature();
        double[] doubles = DataUtils.generateSamples((double)0.0, (double)10.0, (int)10);
        List values = Arrays.stream(doubles).mapToObj(Value::new).collect(Collectors.toList());
        GenericFeatureDistribution numericFeatureDistribution = new GenericFeatureDistribution(feature, values);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)numericFeatureDistribution.getAllSamples().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)numericFeatureDistribution.sample(3).size());
        Assertions.assertThat((double)numericFeatureDistribution.sample().asNumber()).isBetween(Double.valueOf(0.0), Double.valueOf(10.0));
    }

    @Test
    void testLargerSamples() {
        Feature feature = TestUtils.getMockedNumericFeature();
        double[] doubles = DataUtils.generateSamples((double)0.0, (double)10.0, (int)10);
        NumericFeatureDistribution numericFeatureDistribution = new NumericFeatureDistribution(feature, doubles);
        List samples = numericFeatureDistribution.sample(21);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)samples);
        org.junit.jupiter.api.Assertions.assertEquals((int)21, (int)samples.size());
        for (Value sample : samples) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)sample);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)sample.getUnderlyingObject());
            Assertions.assertThat((double)sample.asNumber()).isBetween(Double.valueOf(0.0), Double.valueOf(10.0));
        }
    }
}

