/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.SimplePrediction;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.utils.ValidationUtils;

class ValidationUtilsTest {
    ValidationUtilsTest() {
    }

    @Test
    void testStableEval() throws ExecutionException, InterruptedException, TimeoutException, ValidationUtils.ValidationException {
        for (int n = 0; n < 10; ++n) {
            Random random = new Random();
            PerturbationContext perturbationContext = new PerturbationContext(Long.valueOf(4L), random, 1);
            LimeConfig config = new LimeConfig().withPerturbationContext(perturbationContext);
            LimeExplainer explainer = new LimeExplainer(config);
            PredictionProvider model = TestUtils.getSumThresholdModel(0.1, 0.1);
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (int i = 0; i < 4; ++i) {
                features.add(FeatureFactory.newNumericalFeature((String)("f-" + i), (Number)Type.NUMBER.randomValue(perturbationContext).asNumber()));
            }
            PredictionInput input = new PredictionInput(features);
            List outputs = (List)model.predictAsync(List.of(input)).get(5L, Config.DEFAULT_ASYNC_TIMEUNIT);
            SimplePrediction prediction = new SimplePrediction(input, (PredictionOutput)outputs.get(0));
            int topK = 1;
            double posScore = 0.6;
            double minScore = 0.6;
            ValidationUtils.validateLocalSaliencyStability((PredictionProvider)model, (Prediction)prediction, (LocalExplainer)explainer, (int)topK, (double)posScore, (double)minScore);
        }
    }
}

