/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Objects;
import java.util.UUID;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;

public abstract class BasePrediction
implements Prediction {
    private final PredictionInput input;
    private final UUID executionId;
    private final PredictionOutput output;

    public BasePrediction(PredictionInput input, PredictionOutput output) {
        this(input, output, UUID.randomUUID());
    }

    public BasePrediction(PredictionInput input, PredictionOutput output, UUID executionId) {
        this.input = input;
        this.output = output;
        this.executionId = executionId;
    }

    @Override
    public PredictionInput getInput() {
        return this.input;
    }

    @Override
    public PredictionOutput getOutput() {
        return this.output;
    }

    @Override
    public UUID getExecutionId() {
        return this.executionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasePrediction that = (BasePrediction)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.executionId, that.executionId) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.executionId, this.output);
    }
}

