/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.mockito.Mockito;

class PredictionInputTest {
    private final PerturbationContext context = new PerturbationContext(new Random(), 1);

    PredictionInputTest() {
    }

    @ParameterizedTest
    @EnumSource
    void testEqualitySingleFeature(Type type) {
        Value v = type.randomValue(this.context);
        Feature mockedFeature = TestUtils.getMockedFeature(type, v);
        PredictionInput input1 = new PredictionInput(List.of(mockedFeature));
        PredictionInput input2 = new PredictionInput(List.of(mockedFeature));
        ((ObjectAssert)Assertions.assertThat((Object)input1).isEqualTo((Object)input2)).isEqualTo((Object)input1);
    }

    @ParameterizedTest
    @EnumSource
    void testEqualityMultipleFeatures(Type type) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < 5; ++i) {
            Value v = type.randomValue(this.context);
            Feature feature = TestUtils.getMockedFeature(type, v);
            features.add(feature);
        }
        PredictionInput input1 = new PredictionInput(features);
        PredictionInput input2 = new PredictionInput(features);
        ((ObjectAssert)Assertions.assertThat((Object)input1).isEqualTo((Object)input2)).isEqualTo((Object)input1);
    }

    @Test
    void testInequality() {
        PredictionInput input1 = new PredictionInput(Collections.emptyList());
        Feature feature = (Feature)Mockito.mock(Feature.class);
        PredictionInput input2 = new PredictionInput(List.of(feature));
        ((ObjectAssert)Assertions.assertThat((Object)input1).isNotEqualTo((Object)input2)).isNotEqualTo(null);
    }
}

