/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingLimeExplainer
extends LimeExplainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordingLimeExplainer.class);
    private final Queue<Prediction> recordedPredictions;

    public RecordingLimeExplainer(int capacity) {
        this(new LimeConfig(), capacity);
    }

    public RecordingLimeExplainer(LimeConfig limeConfig, int capacity) {
        super(limeConfig);
        this.recordedPredictions = new FixedSizeConcurrentLinkedDeque<Prediction>(capacity);
    }

    @Override
    public CompletableFuture<Map<String, Saliency>> explainAsync(Prediction prediction, PredictionProvider model) {
        if (!this.recordedPredictions.offer(prediction)) {
            LOGGER.debug("Prediction {} not recorded", (Object)prediction);
        }
        return super.explainAsync(prediction, model);
    }

    public List<Prediction> getRecordedPredictions() {
        Prediction[] a = this.recordedPredictions.toArray(new Prediction[0]);
        return Collections.unmodifiableList(Arrays.asList(a));
    }

    static class FixedSizeConcurrentLinkedDeque<T>
    extends ConcurrentLinkedDeque<T> {
        private final int capacity;

        FixedSizeConcurrentLinkedDeque(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public boolean offer(T o) {
            return !this.contains(o) && super.offer(o) && (this.size() <= this.capacity || super.pop() != null);
        }
    }
}

