/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Optional;
import java.util.Random;

public class PerturbationContext {
    private final Optional<Long> seed;
    private final Random random;
    private final int noOfPerturbations;

    public PerturbationContext(Random random, int noOfPerturbations) {
        this.seed = Optional.empty();
        this.random = random;
        this.noOfPerturbations = noOfPerturbations;
    }

    public PerturbationContext(Long seed, Random random, int noOfPerturbations) {
        this.seed = Optional.ofNullable(seed);
        this.random = random;
        if (seed != null) {
            random.setSeed(seed);
        }
        this.noOfPerturbations = noOfPerturbations;
    }

    public int getNoOfPerturbations() {
        return this.noOfPerturbations;
    }

    public Random getRandom() {
        return this.random;
    }

    public Optional<Long> getSeed() {
        return this.seed;
    }

    public String toString() {
        return "PerturbationContext{random=" + this.random + ", noOfPerturbations=" + this.noOfPerturbations + ", seed=" + this.seed + "}";
    }
}

