/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBinaryEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCompositeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCurrencyEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDurationEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedIntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedTextEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedTimeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedURIEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedVectorEntity;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.PredictionFeatureDomain;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.domain.FeatureDomain;

public class CounterfactualEntityFactory {
    private CounterfactualEntityFactory() {
    }

    public static CounterfactualEntity from(Feature feature, Boolean isConstrained, FeatureDomain featureDomain) {
        return CounterfactualEntityFactory.from(feature, isConstrained, featureDomain, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CounterfactualEntity from(Feature feature, Boolean isConstrained, FeatureDomain featureDomain, FeatureDistribution featureDistribution) {
        void var4_21;
        Object var4_4 = null;
        CounterfactualEntityFactory.validateFeature(feature);
        if (feature.getType() == Type.NUMBER) {
            if (feature.getValue().getUnderlyingObject() instanceof Double) {
                if (isConstrained.booleanValue()) {
                    FixedDoubleEntity fixedDoubleEntity = FixedDoubleEntity.from(feature);
                    return var4_21;
                } else {
                    DoubleEntity doubleEntity = DoubleEntity.from(feature, featureDomain.getLowerBound(), featureDomain.getUpperBound(), featureDistribution, isConstrained);
                }
                return var4_21;
            } else {
                if (!(feature.getValue().getUnderlyingObject() instanceof Integer)) return var4_21;
                if (isConstrained.booleanValue()) {
                    FixedIntegerEntity fixedIntegerEntity = FixedIntegerEntity.from(feature);
                    return var4_21;
                } else {
                    IntegerEntity integerEntity = IntegerEntity.from(feature, featureDomain.getLowerBound().intValue(), featureDomain.getUpperBound().intValue(), featureDistribution, isConstrained);
                }
            }
            return var4_21;
        } else if (feature.getType() == Type.BOOLEAN) {
            if (isConstrained.booleanValue()) {
                FixedBooleanEntity fixedBooleanEntity = FixedBooleanEntity.from(feature);
                return var4_21;
            } else {
                BooleanEntity booleanEntity = BooleanEntity.from(feature, isConstrained);
            }
            return var4_21;
        } else if (feature.getType() == Type.TEXT) {
            if (!isConstrained.booleanValue()) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedTextEntity fixedTextEntity = FixedTextEntity.from(feature);
            return var4_21;
        } else if (feature.getType() == Type.BINARY) {
            if (!isConstrained.booleanValue()) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedBinaryEntity fixedBinaryEntity = FixedBinaryEntity.from(feature);
            return var4_21;
        } else if (feature.getType() == Type.URI) {
            if (!isConstrained.booleanValue()) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedURIEntity fixedURIEntity = FixedURIEntity.from(feature);
            return var4_21;
        } else if (feature.getType() == Type.TIME) {
            if (!isConstrained.booleanValue()) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedTimeEntity fixedTimeEntity = FixedTimeEntity.from(feature);
            return var4_21;
        } else if (feature.getType() == Type.DURATION) {
            if (!isConstrained.booleanValue()) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedDurationEntity fixedDurationEntity = FixedDurationEntity.from(feature);
            return var4_21;
        } else if (feature.getType() == Type.VECTOR) {
            if (!isConstrained.booleanValue()) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedVectorEntity fixedVectorEntity = FixedVectorEntity.from(feature);
            return var4_21;
        } else if (feature.getType() == Type.COMPOSITE) {
            if (!isConstrained.booleanValue()) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedCompositeEntity fixedCompositeEntity = FixedCompositeEntity.from(feature);
            return var4_21;
        } else if (feature.getType() == Type.CURRENCY) {
            if (!isConstrained.booleanValue()) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedCurrencyEntity fixedCurrencyEntity = FixedCurrencyEntity.from(feature);
            return var4_21;
        } else {
            if (feature.getType() != Type.CATEGORICAL) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            if (isConstrained.booleanValue()) {
                FixedCategoricalEntity fixedCategoricalEntity = FixedCategoricalEntity.from(feature);
                return var4_21;
            } else {
                CategoricalEntity categoricalEntity = CategoricalEntity.from(feature, featureDomain.getCategories(), isConstrained);
            }
        }
        return var4_21;
    }

    public static void validateFeature(Feature feature) {
        Type type = feature.getType();
        Object object = feature.getValue().getUnderlyingObject();
        if (type == Type.NUMBER && object == null) {
            throw new IllegalArgumentException("Null numeric features are not supported in counterfactuals");
        }
    }

    public static List<CounterfactualEntity> createEntities(PredictionInput predictionInput, PredictionFeatureDomain featureDomain, List<Boolean> constraints, DataDistribution dataDistribution) {
        List<FeatureDomain> domains = featureDomain.getFeatureDomains();
        return IntStream.range(0, predictionInput.getFeatures().size()).mapToObj(featureIndex -> {
            Feature feature = predictionInput.getFeatures().get(featureIndex);
            Boolean isConstrained = (Boolean)constraints.get(featureIndex);
            FeatureDomain domain = (FeatureDomain)domains.get(featureIndex);
            FeatureDistribution featureDistribution = Optional.ofNullable(dataDistribution).map(dd -> dd.asFeatureDistributions().get(featureIndex)).orElse(null);
            return CounterfactualEntityFactory.from(feature, isConstrained, domain, featureDistribution);
        }).collect(Collectors.toList());
    }
}

