/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.kie.kogito.explainability.model.Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndependentSparseFeatureBalanceFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndependentSparseFeatureBalanceFilter.class);

    IndependentSparseFeatureBalanceFilter() {
    }

    void apply(double[] coefficients, List<Feature> linearizedTargetInputFeatures, List<Pair<double[], Double>> trainingSet) {
        if (coefficients.length != linearizedTargetInputFeatures.size()) {
            LOGGER.warn("coefficients size {} \u2260 features size {}, not filtering", (Object)coefficients.length, (Object)linearizedTargetInputFeatures.size());
            return;
        }
        if (trainingSet.isEmpty()) {
            LOGGER.debug("trainingSet is empty");
            return;
        }
        int ts = linearizedTargetInputFeatures.size();
        double[] zeroPredicted = new double[ts];
        double[] onePredicted = new double[ts];
        for (Pair<double[], Double> sample : trainingSet) {
            double[] sparseVector = (double[])sample.getKey();
            for (int i = 0; i < sparseVector.length; ++i) {
                double inputValue = sparseVector[i];
                Double outputValue = (Double)sample.getValue();
                if (1.0 == outputValue) {
                    int n = i;
                    onePredicted[n] = onePredicted[n] + inputValue;
                    continue;
                }
                int n = i;
                zeroPredicted[n] = zeroPredicted[n] + inputValue;
            }
        }
        zeroPredicted = Arrays.stream(zeroPredicted).map(d -> d / (double)trainingSet.size()).toArray();
        onePredicted = Arrays.stream(onePredicted).map(d -> d / (double)trainingSet.size()).toArray();
        int i = 0;
        while (i < coefficients.length) {
            double zeroDistance = Math.abs(0.5 - zeroPredicted[i]);
            double oneDistance = Math.abs(0.5 - onePredicted[i]);
            double zm = Math.tanh(0.01 + zeroDistance + oneDistance + (double)ts / 10.0);
            int n = i++;
            coefficients[n] = coefficients[n] * zm;
        }
    }
}

