/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.shap;

import java.security.SecureRandom;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.math3.linear.RealMatrix;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.utils.MatrixUtilsExtensions;

public class ShapConfig {
    private final LinkType link;
    private final RegularizerType regularizerType;
    private final Integer nRegularizationFeatures;
    private final Integer nSamples;
    private final double confidence;
    private final PerturbationContext pc;
    private final Executor executor;
    private final List<PredictionInput> background;
    private final RealMatrix backgroundMatrix;

    protected ShapConfig(LinkType link, List<PredictionInput> background, PerturbationContext pc, Executor executor, Integer nSamples, double confidence, RegularizerType regularizerType, Integer nRegularizationFeatures) {
        this.link = link;
        this.background = background;
        this.backgroundMatrix = MatrixUtilsExtensions.matrixFromPredictionInput(background);
        this.pc = pc;
        this.executor = executor;
        this.nSamples = nSamples;
        this.confidence = confidence;
        this.regularizerType = regularizerType;
        this.nRegularizationFeatures = nRegularizationFeatures;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LinkType getLink() {
        return this.link;
    }

    public PerturbationContext getPC() {
        return this.pc;
    }

    public RealMatrix getBackgroundMatrix() {
        return this.backgroundMatrix;
    }

    public List<PredictionInput> getBackground() {
        return this.background;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Optional<Integer> getNSamples() {
        return Optional.ofNullable(this.nSamples);
    }

    public double getConfidence() {
        return this.confidence;
    }

    public RegularizerType getRegularizerType() {
        return this.regularizerType;
    }

    public Integer getNRegularizationFeatures() {
        return this.nRegularizationFeatures;
    }

    public static class Builder {
        private LinkType builderLink;
        private List<PredictionInput> builderBackground;
        private Executor builderExecutor = ForkJoinPool.commonPool();
        private Integer builderNSamples = null;
        private RegularizerType builderRegularizerType = RegularizerType.AUTO;
        private Integer builderNRegularizerFeatures = null;
        private double builderConfidence = 0.95;
        private PerturbationContext builderPC = new PerturbationContext(new SecureRandom(), 0);

        private Builder() {
        }

        public Builder copy() {
            Builder output = new Builder().withLink(this.builderLink).withBackground(this.builderBackground).withExecutor(this.builderExecutor).withConfidence(this.builderConfidence).withPC(this.builderPC);
            output.builderRegularizerType = this.builderRegularizerType;
            output.builderNRegularizerFeatures = this.builderNRegularizerFeatures;
            return output;
        }

        public Builder withLink(LinkType link) {
            this.builderLink = link;
            return this;
        }

        public Builder withBackground(List<PredictionInput> background) {
            this.builderBackground = background;
            return this;
        }

        public Builder withExecutor(Executor executor) {
            this.builderExecutor = executor;
            return this;
        }

        public Builder withNSamples(Integer nSamples) {
            this.builderNSamples = nSamples;
            return this;
        }

        public Builder withConfidence(double confidence) {
            this.builderConfidence = confidence;
            return this;
        }

        public Builder withPC(PerturbationContext pc) {
            this.builderPC = pc;
            return this;
        }

        public Builder withRegularizer(RegularizerType rt) {
            if (rt == RegularizerType.TOP_N_FEATURES) {
                throw new IllegalArgumentException("To use a top-n feature regularizer, simply pass the desired number of features as an integer");
            }
            this.builderRegularizerType = rt;
            return this;
        }

        public Builder withRegularizer(int nTopFeatures) {
            this.builderRegularizerType = RegularizerType.TOP_N_FEATURES;
            this.builderNRegularizerFeatures = nTopFeatures;
            return this;
        }

        public ShapConfig build() {
            if (this.builderLink == null || this.builderBackground == null) {
                throw new IllegalArgumentException("Both a link function and background must beprovided to the ShapConfig");
            }
            if (this.builderBackground.isEmpty()) {
                throw new IllegalArgumentException("Background data list cannot be empty.");
            }
            return new ShapConfig(this.builderLink, this.builderBackground, this.builderPC, this.builderExecutor, this.builderNSamples, this.builderConfidence, this.builderRegularizerType, this.builderNRegularizerFeatures);
        }
    }

    public static enum RegularizerType {
        AUTO,
        AIC,
        BIC,
        TOP_N_FEATURES,
        NONE;

    }

    public static enum LinkType {
        LOGIT,
        IDENTITY;

    }
}

