/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.lime.IndependentSparseFeatureBalanceFilter;
import org.kie.kogito.explainability.model.Feature;

class IndependentSparseFeatureBalanceFilterTest {
    IndependentSparseFeatureBalanceFilterTest() {
    }

    @Test
    void testNoFilterWithNonMatchingSizes() {
        IndependentSparseFeatureBalanceFilter filter = new IndependentSparseFeatureBalanceFilter();
        int size = 3;
        double[] coefficients = new double[size];
        Arrays.fill(coefficients, 1.0);
        double[] copy = Arrays.copyOf(coefficients, 3);
        ArrayList<Feature> features = new ArrayList<Feature>(1);
        features.add(TestUtils.getMockedNumericFeature());
        ArrayList<Pair<double[], Double>> trainingSet = new ArrayList<Pair<double[], Double>>();
        double[] sampleWeights = new double[size];
        TestUtils.fillBalancedDataForFiltering(size, trainingSet, sampleWeights);
        filter.apply(coefficients, features, trainingSet);
        AssertionsForClassTypes.assertThat((double[])coefficients).isEqualTo((Object)copy);
    }

    @Test
    void testFilter() {
        IndependentSparseFeatureBalanceFilter filter = new IndependentSparseFeatureBalanceFilter();
        int size = 2;
        double[] coefficients = new double[size];
        Arrays.fill(coefficients, 1.0);
        double[] copy = Arrays.copyOf(coefficients, size);
        ArrayList<Feature> features = new ArrayList<Feature>(1);
        features.add(TestUtils.getMockedNumericFeature());
        features.add(TestUtils.getMockedNumericFeature());
        ArrayList<Pair<double[], Double>> trainingSet = new ArrayList<Pair<double[], Double>>();
        double[] sampleWeights = new double[size];
        TestUtils.fillBalancedDataForFiltering(size, trainingSet, sampleWeights);
        filter.apply(coefficients, features, trainingSet);
        AssertionsForClassTypes.assertThat((double[])coefficients).isNotEqualTo((Object)copy);
    }
}

