/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.lime.SampleWeighter;
import org.kie.kogito.explainability.model.Feature;

class SampleWeighterTest {
    SampleWeighterTest() {
    }

    @Test
    void testSamplingEmptyDataset() {
        LinkedList trainingSet = new LinkedList();
        LinkedList features = new LinkedList();
        double[] sampleWeights = SampleWeighter.getSampleWeights(features, trainingSet, (double)0.5);
        Assertions.assertEquals((int)0, (int)sampleWeights.length);
    }

    @Test
    void testSamplingNonEmptyDataset() {
        int i;
        LinkedList<Pair> trainingSet = new LinkedList<Pair>();
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (i = 0; i < 5; ++i) {
            features.add(TestUtils.getMockedNumericFeature(1.0));
        }
        for (i = 0; i < 10; ++i) {
            double[] vector = new double[features.size()];
            Arrays.fill(vector, 1.0 / (1.0 + (double)i));
            Pair doubles = Pair.of((Object)vector, (Object)0.0);
            trainingSet.add(doubles);
        }
        double[] weights = SampleWeighter.getSampleWeights(features, trainingSet, (double)0.5);
        for (int i2 = 0; i2 < weights.length - 1; ++i2) {
            Assertions.assertTrue((weights[i2] > weights[i2 + 1] ? 1 : 0) != 0);
        }
    }
}

