/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;
import org.kie.kogito.explainability.utils.CompositeFeatureUtils;

class CompositeFeatureUtilsTest {
    CompositeFeatureUtilsTest() {
    }

    @Test
    void testAlreadyLinear() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(FeatureFactory.newTextFeature((String)"f-1", (String)"foo"));
        features.add(FeatureFactory.newNumericalFeature((String)"f-2", (Number)100.0));
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        List flattened = CompositeFeatureUtils.flattenFeatures(features);
        Assertions.assertEquals(features, (Object)flattened);
        Assertions.assertNotSame(features, (Object)flattened);
        Assertions.assertEquals((int)features.size(), (int)flattened.size());
        List unflattened = CompositeFeatureUtils.unflattenFeatures((List)flattened, features);
        Assertions.assertEquals(features, (Object)unflattened);
        Assertions.assertNotSame(features, (Object)unflattened);
        Assertions.assertEquals((int)features.size(), (int)unflattened.size());
    }

    @Test
    void testSingleCompositeList() {
        Feature composite = FeatureFactory.newCompositeFeature((String)"composite", List.of(FeatureFactory.newTextFeature((String)"f-1", (String)"foo"), FeatureFactory.newNumericalFeature((String)"f-2", (Number)100.0), FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true)));
        List<Feature> features = List.of(composite);
        List flattened = CompositeFeatureUtils.flattenFeatures(features);
        Assertions.assertEquals((int)1, (int)features.size());
        Assertions.assertEquals((int)3, (int)flattened.size());
        Assertions.assertEquals((Object)"f-1", (Object)((Feature)flattened.get(0)).getName());
        Assertions.assertEquals((Object)"f-2", (Object)((Feature)flattened.get(1)).getName());
        Assertions.assertEquals((Object)"f-3", (Object)((Feature)flattened.get(2)).getName());
        List unflattened = CompositeFeatureUtils.unflattenFeatures((List)flattened, features);
        Assertions.assertEquals((int)1, (int)unflattened.size());
        Assertions.assertEquals(features, (Object)unflattened);
    }

    @Test
    void testMixedWithCompositeList() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        Feature composite = FeatureFactory.newCompositeFeature((String)"composite", List.of(FeatureFactory.newTextFeature((String)"f-1", (String)"foo"), FeatureFactory.newNumericalFeature((String)"f-2", (Number)100.0), FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true)));
        features.add(FeatureFactory.newNumericalFeature((String)"g-1", (Number)200.0));
        features.add(composite);
        List flattened = CompositeFeatureUtils.flattenFeatures(features);
        Assertions.assertEquals((int)4, (int)flattened.size());
        Assertions.assertEquals((Object)"g-1", (Object)((Feature)flattened.get(0)).getName());
        Assertions.assertEquals((Object)"f-1", (Object)((Feature)flattened.get(1)).getName());
        List unflattened = CompositeFeatureUtils.unflattenFeatures((List)flattened, features);
        Assertions.assertEquals((int)2, (int)unflattened.size());
        Assertions.assertEquals(features, (Object)unflattened);
        Assertions.assertNotSame(features, (Object)unflattened);
        Assertions.assertEquals((Object)"g-1", (Object)((Feature)unflattened.get(0)).getName());
        Assertions.assertEquals((Object)"composite", (Object)((Feature)unflattened.get(1)).getName());
        Assertions.assertEquals((int)3, (int)((List)((Feature)unflattened.get(1)).getValue().getUnderlyingObject()).size());
        Assertions.assertEquals((Object)"f-1", (Object)((Feature)((List)((Feature)unflattened.get(1)).getValue().getUnderlyingObject()).get(0)).getName());
        Assertions.assertEquals((Object)"f-2", (Object)((Feature)((List)((Feature)unflattened.get(1)).getValue().getUnderlyingObject()).get(1)).getName());
        Assertions.assertEquals((Object)"f-3", (Object)((Feature)((List)((Feature)unflattened.get(1)).getValue().getUnderlyingObject()).get(2)).getName());
    }

    @Test
    void testFixedCompositeMap() {
        LinkedList transactions = new LinkedList();
        HashMap<String, Object> t1 = new HashMap<String, Object>();
        t1.put("Card Type", "Prepaid");
        t1.put("Location", "Global");
        t1.put("Amount", 146.0);
        t1.put("Auth Code", "Approved");
        transactions.add(t1);
        HashMap<String, Object> t2 = new HashMap<String, Object>();
        t2.put("Card Type", "Debit");
        t2.put("Location", "Local");
        t2.put("Amount", 512.0);
        t2.put("Auth Code", "Denied");
        transactions.add(t2);
        HashMap map = new HashMap();
        map.put("Transactions", transactions);
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(FeatureFactory.newCompositeFeature((String)"composite", map));
        List flattened = CompositeFeatureUtils.flattenFeatures(features);
        Assertions.assertEquals((int)8, (int)flattened.size());
        List unflattened = CompositeFeatureUtils.unflattenFeatures((List)flattened, features);
        Assertions.assertEquals((int)1, (int)unflattened.size());
        Assertions.assertEquals(features, (Object)unflattened);
    }

    @Test
    void testVariableCompositeMap() {
        LinkedList transactions = new LinkedList();
        HashMap<String, String> t1 = new HashMap<String, String>();
        t1.put("Card Type", "Prepaid");
        t1.put("Location", "Global");
        t1.put("Amount", (String)FeatureFactory.newNumericalFeature((String)"Amount", (Number)146.0, (FeatureDomain)NumericalFeatureDomain.create((double)0.0, (double)1000.0)));
        t1.put("Auth Code", (String)FeatureFactory.newBooleanFeature((String)"Auth Code", (Boolean)true, (FeatureDomain)EmptyFeatureDomain.create()));
        transactions.add(t1);
        HashMap<String, String> t2 = new HashMap<String, String>();
        t2.put("Card Type", "Debit");
        t2.put("Location", "Local");
        t2.put("Amount", (String)FeatureFactory.newNumericalFeature((String)"Amount", (Number)512.0, (FeatureDomain)NumericalFeatureDomain.create((double)0.0, (double)1000.0)));
        t2.put("Auth Code", (String)FeatureFactory.newBooleanFeature((String)"Auth Code", (Boolean)false, (FeatureDomain)EmptyFeatureDomain.create()));
        transactions.add(t2);
        HashMap map = new HashMap();
        map.put("Transactions", transactions);
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(FeatureFactory.newCompositeFeature((String)"composite", map));
        List flattened = CompositeFeatureUtils.flattenFeatures(features);
        Assertions.assertEquals((int)8, (int)flattened.size());
        List unflattened = CompositeFeatureUtils.unflattenFeatures((List)flattened, features);
        Assertions.assertEquals((int)1, (int)unflattened.size());
        Assertions.assertEquals(features, (Object)unflattened);
    }
}

