/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.time.Duration;
import org.kie.kogito.explainability.local.counterfactual.entities.AbstractAlgebraicEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class DurationEntity
extends AbstractAlgebraicEntity<Duration> {
    public DurationEntity() {
    }

    private DurationEntity(Duration originalValue, String featureName, Duration minimum, Duration maximum, FeatureDistribution featureDistribution, boolean constrained) {
        super(originalValue, featureName, minimum, maximum, constrained);
        this.range = maximum.getSeconds() - minimum.getSeconds();
    }

    public static DurationEntity from(Feature originalFeature, Duration minimum, Duration maximum, boolean constrained) {
        return DurationEntity.from(originalFeature, minimum, maximum, null, constrained);
    }

    public static DurationEntity from(Feature originalFeature, Duration minimum, Duration maximum, FeatureDistribution featureDistribution, boolean constrained) {
        return new DurationEntity((Duration)originalFeature.getValue().getUnderlyingObject(), originalFeature.getName(), minimum, maximum, featureDistribution, constrained);
    }

    public static DurationEntity from(Feature originalFeature, Duration minimum, Duration maximum) {
        return DurationEntity.from(originalFeature, minimum, maximum, null, false);
    }

    public static DurationEntity from(Feature originalFeature, Duration minimum, Duration maximum, FeatureDistribution featureDistribution) {
        return DurationEntity.from(originalFeature, minimum, maximum, featureDistribution, false);
    }

    @ValueRangeProvider(id="doubleRange")
    public ValueRange<Double> getValueRange() {
        return ValueRangeFactory.createDoubleValueRange((double)((Duration)this.rangeMinimum).getSeconds(), (double)((Duration)this.rangeMaximum).getSeconds());
    }

    @PlanningVariable(valueRangeProviderRefs={"doubleRange"})
    public Duration getProposedValue() {
        return (Duration)this.proposedValue;
    }

    public void setProposedValue(Duration proposedValue) {
        this.proposedValue = proposedValue;
    }

    @Override
    public double distance() {
        return Math.abs(((Duration)this.proposedValue).getSeconds() - ((Duration)this.originalValue).getSeconds());
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newDurationFeature(this.featureName, (Duration)this.proposedValue);
    }

    @Override
    public double similarity() {
        return 1.0 - (double)Math.abs(((Duration)this.proposedValue).getSeconds() - ((Duration)this.originalValue).getSeconds()) / this.range;
    }
}

