/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.kie.kogito.explainability.local.counterfactual.entities.AbstractAlgebraicEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class TimeEntity
extends AbstractAlgebraicEntity<LocalTime> {
    public TimeEntity() {
    }

    private TimeEntity(LocalTime originalValue, String featureName, LocalTime minimum, LocalTime maximum, FeatureDistribution featureDistribution, boolean constrained) {
        super(originalValue, featureName, minimum, maximum, constrained);
        this.range = minimum.until(maximum, ChronoUnit.SECONDS);
    }

    public static TimeEntity from(Feature originalFeature, LocalTime minimum, LocalTime maximum, boolean constrained) {
        return TimeEntity.from(originalFeature, minimum, maximum, null, constrained);
    }

    public static TimeEntity from(Feature originalFeature, LocalTime minimum, LocalTime maximum, FeatureDistribution featureDistribution, boolean constrained) {
        return new TimeEntity((LocalTime)originalFeature.getValue().getUnderlyingObject(), originalFeature.getName(), minimum, maximum, featureDistribution, constrained);
    }

    public static TimeEntity from(Feature originalFeature, LocalTime minimum, LocalTime maximum) {
        return TimeEntity.from(originalFeature, minimum, maximum, null, false);
    }

    public static TimeEntity from(Feature originalFeature, LocalTime minimum, LocalTime maximum, FeatureDistribution featureDistribution) {
        return TimeEntity.from(originalFeature, minimum, maximum, featureDistribution, false);
    }

    @ValueRangeProvider(id="doubleRange")
    public ValueRange<Double> getValueRange() {
        double minimum = LocalTime.MIN.until((Temporal)this.rangeMinimum, ChronoUnit.SECONDS);
        double maximum = LocalTime.MIN.until((Temporal)this.rangeMaximum, ChronoUnit.SECONDS);
        return ValueRangeFactory.createDoubleValueRange((double)minimum, (double)maximum);
    }

    @PlanningVariable(valueRangeProviderRefs={"doubleRange"})
    public LocalTime getProposedValue() {
        return (LocalTime)this.proposedValue;
    }

    public void setProposedValue(LocalTime proposedValue) {
        this.proposedValue = proposedValue;
    }

    @Override
    public double distance() {
        return Math.abs(((LocalTime)this.proposedValue).until((Temporal)this.originalValue, ChronoUnit.SECONDS));
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newTimeFeature(this.featureName, (LocalTime)this.proposedValue);
    }

    @Override
    public double similarity() {
        return 1.0 - (double)Math.abs(((LocalTime)this.proposedValue).until((Temporal)this.originalValue, ChronoUnit.SECONDS)) / this.range;
    }
}

