/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.GenericFeatureDistribution;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

public class PredictionInputsDataDistribution
implements DataDistribution {
    private final List<PredictionInput> inputs;
    private final Random random;

    public PredictionInputsDataDistribution(List<PredictionInput> inputs) {
        this(inputs, new SecureRandom());
    }

    public PredictionInputsDataDistribution(List<PredictionInput> inputs, Random random) {
        this.inputs = Collections.unmodifiableList(inputs);
        this.random = random;
    }

    @Override
    public PredictionInput sample() {
        if (this.inputs.isEmpty()) {
            return new PredictionInput(Collections.emptyList());
        }
        List<PredictionInput> singleSample = this.sample(1);
        if (singleSample.isEmpty()) {
            return new PredictionInput(Collections.emptyList());
        }
        return singleSample.get(0);
    }

    @Override
    public List<PredictionInput> sample(int sampleSize) {
        return DataUtils.sampleWithReplacement(this.inputs, sampleSize, this.random);
    }

    @Override
    public List<PredictionInput> getAllSamples() {
        ArrayList<PredictionInput> copy = new ArrayList<PredictionInput>(this.inputs);
        Collections.shuffle(copy);
        return copy;
    }

    @Override
    public List<FeatureDistribution> asFeatureDistributions() {
        if (this.inputs.isEmpty()) {
            return Collections.emptyList();
        }
        PredictionInput firstInput = this.inputs.get(0);
        List<Feature> linearizedFeatures = DataUtils.getLinearizedFeatures(firstInput.getFeatures());
        int shape = linearizedFeatures.size();
        ArrayList<FeatureDistribution> featureDistributions = new ArrayList<FeatureDistribution>(shape);
        for (int i = 0; i < shape; ++i) {
            Feature firstInputIthfeature = linearizedFeatures.get(i);
            ArrayList<Value> values = new ArrayList<Value>(this.inputs.size());
            for (PredictionInput input : this.inputs) {
                List<Feature> currentInputLinearizedFeatures = DataUtils.getLinearizedFeatures(input.getFeatures());
                if (currentInputLinearizedFeatures.size() > i) {
                    values.add(currentInputLinearizedFeatures.get(i).getValue());
                    continue;
                }
                values.add(new Value(null));
            }
            Feature feature = FeatureFactory.copyOf(firstInputIthfeature, new Value(null));
            featureDistributions.add(new GenericFeatureDistribution(feature, values));
        }
        return featureDistributions;
    }

    @Override
    public boolean isEmpty() {
        return this.inputs.isEmpty();
    }

    public String toString() {
        return "PredictionInputsDataDistribution{inputs=" + this.inputs + ", random=" + this.random + "}";
    }
}

