/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

public class CompositeFeatureUtils {
    private CompositeFeatureUtils() {
    }

    public static List<Feature> flattenFeatures(List<Feature> features) {
        return DataUtils.getLinearizedFeatures(features);
    }

    public static List<Feature> unflattenFeatures(List<Feature> flattenedFeatures, List<Feature> originalFeatures) {
        AtomicInteger tracker = new AtomicInteger();
        return originalFeatures.stream().map(feature -> CompositeFeatureUtils.unravel(flattenedFeatures, tracker, feature)).collect(Collectors.toList());
    }

    private static Feature unravel(List<Feature> flattenedFeatures, AtomicInteger tracker, Feature f) {
        Feature extractedFeature;
        Object featureObject = f.getValue().getUnderlyingObject();
        switch (f.getType()) {
            case UNDEFINED: {
                if (featureObject instanceof Feature) {
                    extractedFeature = FeatureFactory.copyOf(f, new Value(CompositeFeatureUtils.unravel(flattenedFeatures, tracker, (Feature)featureObject)));
                    break;
                }
                extractedFeature = FeatureFactory.copyOf(f, flattenedFeatures.get(tracker.getAndIncrement()).getValue());
                break;
            }
            case COMPOSITE: {
                if (featureObject instanceof List) {
                    extractedFeature = FeatureFactory.newCompositeFeature(f.getName(), ((List)featureObject).stream().map(feature -> CompositeFeatureUtils.unravel(flattenedFeatures, tracker, feature)).collect(Collectors.toList()));
                    break;
                }
                extractedFeature = FeatureFactory.copyOf(f, flattenedFeatures.get(tracker.getAndIncrement()).getValue());
                break;
            }
            default: {
                extractedFeature = FeatureFactory.copyOf(f, flattenedFeatures.get(tracker.getAndIncrement()).getValue());
            }
        }
        return extractedFeature;
    }
}

