/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.counterfactual.CounterFactualScoreCalculator;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualSolution;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PredictionFeatureDomain;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;

class CounterfactualScoreCalculatorTest {
    CounterfactualScoreCalculatorTest() {
    }

    private static Output outputFromFeature(Feature feature) {
        return new Output(feature.getName(), feature.getType(), feature.getValue(), 0.0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void IntegerDistanceSameValue(int seed) {
        Random random = new Random(seed);
        int value = random.nextInt();
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)Math.abs(distance));
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void IntegerDistanceSameValueZero(int seed) {
        Random random = new Random(seed);
        boolean value = false;
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)0);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)Math.abs(distance));
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceSameValue(int seed) {
        Random random = new Random(seed);
        double value = random.nextDouble();
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceSameValueZero(int seed) {
        Random random = new Random(seed);
        double value = 0.0;
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)0.0);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)0.0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void BooleanDistanceSameValue(int seed) {
        Random random = new Random(seed);
        boolean value = random.nextBoolean();
        Feature x = FeatureFactory.newBooleanFeature((String)"x", (Boolean)value);
        Feature y = FeatureFactory.newBooleanFeature((String)"y", (Boolean)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @Test
    void BooleanDistanceNull() {
        Feature predictionFeature = FeatureFactory.newBooleanFeature((String)"x", (Boolean)true);
        Feature goalFeature = FeatureFactory.newBooleanFeature((String)"y", null);
        Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)goalOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newBooleanFeature((String)"x", null);
        goalFeature = FeatureFactory.newBooleanFeature((String)"y", (Boolean)false);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)predictionOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newBooleanFeature((String)"x", null);
        goalFeature = FeatureFactory.newBooleanFeature((String)"y", null);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)predictionOutput.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void CategoricalDistanceSameValue(int seed) {
        Random random = new Random(seed);
        String value = UUID.randomUUID().toString();
        Feature x = FeatureFactory.newCategoricalFeature((String)"x", (String)value);
        Feature y = FeatureFactory.newCategoricalFeature((String)"y", (String)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.CATEGORICAL, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void CategoricalDistanceNull(int seed) {
        Random random = new Random(seed);
        String value = UUID.randomUUID().toString();
        Feature predictionFeature = FeatureFactory.newCategoricalFeature((String)"x", (String)value);
        Feature goalFeature = FeatureFactory.newCategoricalFeature((String)"y", null);
        Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.CATEGORICAL, (Object)goalOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newCategoricalFeature((String)"x", null);
        goalFeature = FeatureFactory.newCategoricalFeature((String)"y", (String)value);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.CATEGORICAL, (Object)predictionOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newCategoricalFeature((String)"x", null);
        goalFeature = FeatureFactory.newCategoricalFeature((String)"y", null);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.CATEGORICAL, (Object)predictionOutput.getType());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void TextDistanceSameValue(int seed) {
        String value = UUID.randomUUID().toString();
        Feature x = FeatureFactory.newTextFeature((String)"x", (String)value);
        Feature y = FeatureFactory.newTextFeature((String)"y", (String)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.TEXT, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void IntegerDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        int value = random.nextInt(1000);
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value + 100));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value - 100));
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void IntegerDistanceDifferentValueThreshold(int seed) {
        Random random = new Random(seed);
        int value = random.nextInt(1000);
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value + 100));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.05);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value - 100));
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.05);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void IntegerDistanceNull(int seed) {
        Random random = new Random(seed);
        int value = random.nextInt(1000);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Feature predictionFeature = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
            Feature goalFeature = FeatureFactory.newNumericalFeature((String)"x", null);
            Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
            Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
            CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        });
        Assertions.assertEquals((Object)"Unsupported NaN or NULL for numeric feature 'x'", (Object)exception.getMessage());
        exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Feature predictionFeature = FeatureFactory.newNumericalFeature((String)"x", null);
            Feature goalFeature = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
            Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
            Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
            CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        });
        Assertions.assertEquals((Object)"Unsupported NaN or NULL for numeric feature 'x'", (Object)exception.getMessage());
        exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Feature predictionFeature = FeatureFactory.newNumericalFeature((String)"x", null);
            Feature goalFeature = FeatureFactory.newNumericalFeature((String)"x", null);
            Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
            Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
            CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        });
        Assertions.assertEquals((Object)"Unsupported NaN or NULL for numeric feature 'x'", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceZero(int seed) {
        Random random = new Random(seed);
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)0.0);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)1.0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        y = FeatureFactory.newNumericalFeature((String)"y", (Number)-1.0);
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceDifferentValueThresholdMet(int seed) {
        double value = 100.0;
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)100.0);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)80.0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.1);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.2);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.3);
        Assertions.assertFalse((distance * distance > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceDifferentValueThreshold(int seed) {
        Random random = new Random(seed);
        double value = random.nextDouble() * 100.0;
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value + 100.0));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.25);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value - 100.0));
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.25);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceNull(int seed) {
        Random random = new Random(seed);
        double value = random.nextDouble() * 1000.0;
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Feature predictionFeature = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
            Feature goalFeature = FeatureFactory.newNumericalFeature((String)"x", null);
            Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
            Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
            CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        });
        Assertions.assertEquals((Object)"Unsupported NaN or NULL for numeric feature 'x'", (Object)exception.getMessage());
        exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Feature predictionFeature = FeatureFactory.newNumericalFeature((String)"x", null);
            Feature goalFeature = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
            Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
            Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
            CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        });
        Assertions.assertEquals((Object)"Unsupported NaN or NULL for numeric feature 'x'", (Object)exception.getMessage());
        exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Feature predictionFeature = FeatureFactory.newNumericalFeature((String)"x", null);
            Feature goalFeature = FeatureFactory.newNumericalFeature((String)"x", null);
            Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
            Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
            CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        });
        Assertions.assertEquals((Object)"Unsupported NaN or NULL for numeric feature 'x'", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void BooleanDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        boolean value = random.nextBoolean();
        Feature x = FeatureFactory.newBooleanFeature((String)"x", (Boolean)value);
        Feature y = FeatureFactory.newBooleanFeature((String)"y", (Boolean)(!value ? 1 : 0));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void BooleanDistanceDifferentValueThreshold(int seed) {
        Random random = new Random(seed);
        boolean value = random.nextBoolean();
        Feature x = FeatureFactory.newBooleanFeature((String)"x", (Boolean)value);
        Feature y = FeatureFactory.newBooleanFeature((String)"y", (Boolean)(!value ? 1 : 0));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.25);
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void CategoricalDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        Feature x = FeatureFactory.newCategoricalFeature((String)"x", (String)UUID.randomUUID().toString());
        Feature y = FeatureFactory.newCategoricalFeature((String)"y", (String)UUID.randomUUID().toString());
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.CATEGORICAL, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.CATEGORICAL, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void currencyDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        Feature x = FeatureFactory.newCurrencyFeature((String)"x", (Currency)Currency.getInstance("GBP"));
        Feature y = FeatureFactory.newCurrencyFeature((String)"y", (Currency)Currency.getInstance("EUR"));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.CURRENCY, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.CURRENCY, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void currencyDistanceNull(int seed) {
        Random random = new Random(seed);
        Currency value = Currency.getInstance(Locale.UK);
        Feature predictionFeature = FeatureFactory.newCurrencyFeature((String)"x", (Currency)value);
        Feature goalFeature = FeatureFactory.newCurrencyFeature((String)"y", null);
        Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.CURRENCY, (Object)goalOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newCurrencyFeature((String)"x", null);
        goalFeature = FeatureFactory.newCurrencyFeature((String)"y", (Currency)value);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.CURRENCY, (Object)predictionOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newCurrencyFeature((String)"x", null);
        goalFeature = FeatureFactory.newCurrencyFeature((String)"y", null);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.CURRENCY, (Object)predictionOutput.getType());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void currencyDistanceSameValue(int seed) {
        Random random = new Random(seed);
        Currency value = Currency.getInstance(Locale.US);
        Feature x = FeatureFactory.newCurrencyFeature((String)"x", (Currency)value);
        Feature y = FeatureFactory.newCurrencyFeature((String)"y", (Currency)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.CURRENCY, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void binaryDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        Feature x = FeatureFactory.newBinaryFeature((String)"x", (ByteBuffer)ByteBuffer.wrap("foo".getBytes()));
        Feature y = FeatureFactory.newBinaryFeature((String)"y", (ByteBuffer)ByteBuffer.wrap("bar".getBytes()));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.BINARY, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.BINARY, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void binaryDistanceNull(int seed) {
        Random random = new Random(seed);
        ByteBuffer value = ByteBuffer.wrap("foo".getBytes());
        Feature predictionFeature = FeatureFactory.newBinaryFeature((String)"x", (ByteBuffer)value);
        Feature goalFeature = FeatureFactory.newBinaryFeature((String)"y", null);
        Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.BINARY, (Object)goalOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newBinaryFeature((String)"x", null);
        goalFeature = FeatureFactory.newBinaryFeature((String)"y", (ByteBuffer)value);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.BINARY, (Object)predictionOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newBinaryFeature((String)"x", null);
        goalFeature = FeatureFactory.newBinaryFeature((String)"y", null);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.BINARY, (Object)predictionOutput.getType());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void objectDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        Feature x = FeatureFactory.newObjectFeature((String)"x", (Object)"test");
        Feature y = FeatureFactory.newObjectFeature((String)"y", (Object)20);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.UNDEFINED, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.UNDEFINED, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void objectDistanceSameValue(int seed) {
        Random random = new Random(seed);
        ByteBuffer value = ByteBuffer.wrap("foo".getBytes());
        Feature x = FeatureFactory.newObjectFeature((String)"x", (Object)value);
        Feature y = FeatureFactory.newObjectFeature((String)"y", (Object)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.UNDEFINED, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void objectDistanceNull(int seed) {
        Random random = new Random(seed);
        ByteBuffer value = ByteBuffer.wrap("foo".getBytes());
        Feature predictionFeature = FeatureFactory.newObjectFeature((String)"x", (Object)value);
        Feature goalFeature = FeatureFactory.newObjectFeature((String)"y", null);
        Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.UNDEFINED, (Object)goalOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newObjectFeature((String)"x", null);
        goalFeature = FeatureFactory.newObjectFeature((String)"y", (Object)value);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.UNDEFINED, (Object)predictionOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newObjectFeature((String)"x", null);
        goalFeature = FeatureFactory.newObjectFeature((String)"y", null);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.UNDEFINED, (Object)predictionOutput.getType());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void binaryDistanceSameValue(int seed) {
        Random random = new Random(seed);
        ByteBuffer value = ByteBuffer.wrap("foo".getBytes());
        Feature x = FeatureFactory.newBinaryFeature((String)"x", (ByteBuffer)value);
        Feature y = FeatureFactory.newBinaryFeature((String)"y", (ByteBuffer)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.BINARY, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @Test
    void durationDistanceDifferentValue() {
        double SECONDS = 120.0;
        Feature x = FeatureFactory.newDurationFeature((String)"x", (Duration)Duration.ZERO);
        Feature y = FeatureFactory.newDurationFeature((String)"y", (Duration)Duration.ofSeconds(120L));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.DURATION, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.DURATION, (Object)oy.getType());
        Assertions.assertEquals((double)120.0, (double)distance);
        x = FeatureFactory.newDurationFeature((String)"x", (Duration)Duration.ofSeconds(120L));
        y = FeatureFactory.newDurationFeature((String)"y", (Duration)Duration.ofDays(1L));
        ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((double)0.9986, (double)distance, (double)0.01);
        x = FeatureFactory.newDurationFeature((String)"x", (Duration)Duration.ofDays(2L));
        y = FeatureFactory.newDurationFeature((String)"y", (Duration)Duration.ofDays(1L));
        ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        System.out.println(distance);
        Assertions.assertEquals((double)0.5, (double)distance, (double)1.0E-4);
    }

    @Test
    void durationDistanceNull() {
        Duration value = Duration.ofHours(72L);
        Feature predictionFeature = FeatureFactory.newDurationFeature((String)"x", (Duration)value);
        Feature goalFeature = FeatureFactory.newDurationFeature((String)"y", null);
        Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.DURATION, (Object)goalOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newDurationFeature((String)"x", null);
        goalFeature = FeatureFactory.newDurationFeature((String)"y", (Duration)value);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.DURATION, (Object)predictionOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newDurationFeature((String)"x", null);
        goalFeature = FeatureFactory.newDurationFeature((String)"y", null);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.DURATION, (Object)predictionOutput.getType());
        System.out.println(distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void durationDistanceSameValue(int seed) {
        Random random = new Random(seed);
        Duration value = Duration.ofSeconds(random.nextLong());
        Feature x = FeatureFactory.newDurationFeature((String)"x", (Duration)value);
        Feature y = FeatureFactory.newDurationFeature((String)"y", (Duration)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.DURATION, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)Math.abs(distance));
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)0.0, (double)Math.abs(distance));
    }

    @Test
    void timeDistanceDifferentValue() {
        LocalTime value = LocalTime.now();
        Feature x = FeatureFactory.newTimeFeature((String)"x", (LocalTime)LocalTime.of(15, 59));
        Feature y = FeatureFactory.newTimeFeature((String)"y", (LocalTime)LocalTime.of(10, 1));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.TIME, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.TIME, (Object)oy.getType());
        Assertions.assertEquals((double)0.248, (double)distance, (double)0.01);
        x = FeatureFactory.newTimeFeature((String)"x", (LocalTime)LocalTime.of(12, 0));
        y = FeatureFactory.newTimeFeature((String)"y", (LocalTime)LocalTime.of(12, 57));
        ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((double)0.039, (double)distance, (double)0.01);
        x = FeatureFactory.newTimeFeature((String)"x", (LocalTime)LocalTime.of(0, 0));
        y = FeatureFactory.newTimeFeature((String)"y", (LocalTime)LocalTime.of(15, 17));
        ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((double)0.636, (double)distance, (double)0.01);
    }

    @Test
    void timeDistanceNull() {
        LocalTime value = LocalTime.of(17, 17);
        Feature predictionFeature = FeatureFactory.newTimeFeature((String)"x", (LocalTime)value);
        Feature goalFeature = FeatureFactory.newTimeFeature((String)"y", null);
        Output predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        Output goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.TIME, (Object)goalOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newTimeFeature((String)"x", null);
        goalFeature = FeatureFactory.newTimeFeature((String)"y", (LocalTime)value);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.TIME, (Object)predictionOutput.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        predictionFeature = FeatureFactory.newTimeFeature((String)"x", null);
        goalFeature = FeatureFactory.newTimeFeature((String)"y", null);
        predictionOutput = CounterfactualScoreCalculatorTest.outputFromFeature(predictionFeature);
        goalOutput = CounterfactualScoreCalculatorTest.outputFromFeature(goalFeature);
        distance = CounterFactualScoreCalculator.outputDistance((Output)predictionOutput, (Output)goalOutput);
        Assertions.assertEquals((Object)Type.TIME, (Object)predictionOutput.getType());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void timeDistanceSameValue(int seed) {
        Random random = new Random(seed);
        LocalTime value = LocalTime.of(random.nextInt(24), random.nextInt(60));
        Feature x = FeatureFactory.newTimeFeature((String)"x", (LocalTime)value);
        Feature y = FeatureFactory.newTimeFeature((String)"y", (LocalTime)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.TIME, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)Math.abs(distance));
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)0.0, (double)Math.abs(distance));
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void TextDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        Feature x = FeatureFactory.newTextFeature((String)"x", (String)UUID.randomUUID().toString());
        Feature y = FeatureFactory.newTextFeature((String)"y", (String)UUID.randomUUID().toString());
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.TEXT, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.TEXT, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @Test
    void differentFeatureTypes() {
        Feature x = FeatureFactory.newCategoricalFeature((String)"x", (String)UUID.randomUUID().toString());
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)0.0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy));
        Assertions.assertEquals((Object)"Features must have the same type. Feature 'x', has type 'categorical' and 'number'", (Object)exception.getMessage());
    }

    @Test
    void unsupportedFeatureType() {
        Feature x = FeatureFactory.newVectorFeature((String)"x", (double[])new double[]{1.0, 2.0, 3.0, 4.0});
        Feature y = FeatureFactory.newVectorFeature((String)"y", (double[])new double[]{5.0, 6.0, 7.0, 8.0});
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy));
        Assertions.assertEquals((Object)"Feature 'x' has unsupported type 'vector'", (Object)exception.getMessage());
    }

    @Test
    void testGoalSizeMatch() throws ExecutionException, InterruptedException {
        CounterFactualScoreCalculator scoreCalculator = new CounterFactualScoreCalculator();
        PredictionProvider model = TestUtils.getFeatureSkipModel(0);
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-1", (Number)1.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newNumericalFeature((String)"f-2", (Number)2.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domains = new PredictionFeatureDomain(featureDomains);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input);
        ArrayList<Output> goal = new ArrayList<Output>();
        goal.add(new Output("f-2", Type.NUMBER, new Value((Object)2.0), 0.0));
        goal.add(new Output("f-3", Type.BOOLEAN, new Value((Object)true), 0.0));
        CounterfactualSolution solution = new CounterfactualSolution(entities, features, model, goal, UUID.randomUUID(), UUID.randomUUID(), 0.0);
        BendableBigDecimalScore score = scoreCalculator.calculateScore(solution);
        List predictionOutputs = (List)model.predictAsync(List.of(input)).get();
        Assertions.assertTrue((boolean)score.isFeasible());
        Assertions.assertEquals((int)2, (int)goal.size());
        Assertions.assertEquals((int)1, (int)predictionOutputs.size());
        Assertions.assertEquals((int)2, (int)((PredictionOutput)predictionOutputs.get(0)).getOutputs().size());
        Assertions.assertEquals((int)0, (int)score.getHardScore(0).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getHardScore(1).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getHardScore(2).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getSoftScore(0).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getSoftScore(1).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)3, (int)score.getHardLevelsSize());
        Assertions.assertEquals((int)2, (int)score.getSoftLevelsSize());
    }

    @Test
    void testGoalSizeSmaller() throws ExecutionException, InterruptedException {
        CounterFactualScoreCalculator scoreCalculator = new CounterFactualScoreCalculator();
        PredictionProvider model = TestUtils.getFeatureSkipModel(0);
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-1", (Number)1.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newNumericalFeature((String)"f-2", (Number)2.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domains = new PredictionFeatureDomain(featureDomains);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input);
        ArrayList<Output> goal = new ArrayList<Output>();
        goal.add(new Output("f-2", Type.NUMBER, new Value((Object)2.0), 0.0));
        List predictionOutputs = (List)model.predictAsync(List.of(input)).get();
        Assertions.assertEquals((int)1, (int)goal.size());
        Assertions.assertEquals((int)1, (int)predictionOutputs.size());
        Assertions.assertEquals((int)2, (int)((PredictionOutput)predictionOutputs.get(0)).getOutputs().size());
        CounterfactualSolution solution = new CounterfactualSolution(entities, features, model, goal, UUID.randomUUID(), UUID.randomUUID(), 0.0);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> scoreCalculator.calculateScore(solution));
        Assertions.assertEquals((Object)"Prediction size must be equal to goal size", (Object)exception.getMessage());
    }

    @Test
    void testGoalSizeLarger() throws ExecutionException, InterruptedException {
        CounterFactualScoreCalculator scoreCalculator = new CounterFactualScoreCalculator();
        PredictionProvider model = TestUtils.getFeatureSkipModel(0);
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-1", (Number)1.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newNumericalFeature((String)"f-2", (Number)2.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domains = new PredictionFeatureDomain(featureDomains);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input);
        ArrayList<Output> goal = new ArrayList<Output>();
        goal.add(new Output("f-1", Type.NUMBER, new Value((Object)1.0), 0.0));
        goal.add(new Output("f-2", Type.NUMBER, new Value((Object)2.0), 0.0));
        goal.add(new Output("f-3", Type.BOOLEAN, new Value((Object)true), 0.0));
        List predictionOutputs = (List)model.predictAsync(List.of(input)).get();
        Assertions.assertEquals((int)3, (int)goal.size());
        Assertions.assertEquals((int)1, (int)predictionOutputs.size());
        Assertions.assertEquals((int)2, (int)((PredictionOutput)predictionOutputs.get(0)).getOutputs().size());
        CounterfactualSolution solution = new CounterfactualSolution(entities, features, model, goal, UUID.randomUUID(), UUID.randomUUID(), 0.0);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> scoreCalculator.calculateScore(solution));
        Assertions.assertEquals((Object)"Prediction size must be equal to goal size", (Object)exception.getMessage());
    }

    @Test
    void testNullBooleanInput() throws ExecutionException, InterruptedException {
        CounterFactualScoreCalculator scoreCalculator = new CounterFactualScoreCalculator();
        PredictionProvider model = TestUtils.getFeatureSkipModel(0);
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-1", (Number)1.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-2", null));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domains = new PredictionFeatureDomain(featureDomains);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input);
        ArrayList<Output> goal = new ArrayList<Output>();
        goal.add(new Output("f-2", Type.BOOLEAN, new Value(null), 0.0));
        goal.add(new Output("f-3", Type.BOOLEAN, new Value((Object)true), 0.0));
        CounterfactualSolution solution = new CounterfactualSolution(entities, features, model, goal, UUID.randomUUID(), UUID.randomUUID(), 0.0);
        BendableBigDecimalScore score = scoreCalculator.calculateScore(solution);
        List predictionOutputs = (List)model.predictAsync(List.of(input)).get();
        Assertions.assertTrue((boolean)score.isFeasible());
        Assertions.assertEquals((int)2, (int)goal.size());
        Assertions.assertEquals((int)1, (int)predictionOutputs.size());
        Assertions.assertEquals((int)2, (int)((PredictionOutput)predictionOutputs.get(0)).getOutputs().size());
        Assertions.assertEquals((int)0, (int)score.getHardScore(0).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getHardScore(1).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getHardScore(2).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getSoftScore(0).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getSoftScore(1).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)3, (int)score.getHardLevelsSize());
        Assertions.assertEquals((int)2, (int)score.getSoftLevelsSize());
    }

    @Test
    void testNullIntegerInput() throws ExecutionException, InterruptedException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-1", (Number)1.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newNumericalFeature((String)"f-2", null));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domains = new PredictionFeatureDomain(featureDomains);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CounterfactualEntityFactory.createEntities((PredictionInput)input));
        Assertions.assertEquals((Object)"Null numeric features are not supported in counterfactuals", (Object)exception.getMessage());
    }

    @Test
    void testNullDoubleInput() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-1", (Number)1.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newNumericalFeature((String)"f-2", null));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domains = new PredictionFeatureDomain(featureDomains);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CounterfactualEntityFactory.createEntities((PredictionInput)input));
        Assertions.assertEquals((Object)"Null numeric features are not supported in counterfactuals", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void testPrimarySoftScore(int seed) {
        Random random = new Random(seed);
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        int nFeatures = 1000;
        for (int n = 0; n < 1000; ++n) {
            features.add(FeatureFactory.newNumericalFeature((String)("f-" + n), (Number)(random.nextDouble() * 1.0E-100)));
            featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
            constraints.add(false);
        }
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domain = new PredictionFeatureDomain(featureDomains);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input);
        CounterFactualScoreCalculator scoreCalculator = new CounterFactualScoreCalculator();
        PredictionProvider model = TestUtils.getFeatureSkipModel(0);
        ArrayList<Output> goal = new ArrayList<Output>();
        for (int n = 1; n < 1000; ++n) {
            goal.add(new Output("f-" + n, Type.NUMBER, ((Feature)features.get(n)).getValue(), 1.0));
        }
        CounterfactualSolution solution = new CounterfactualSolution(entities, features, model, goal, UUID.randomUUID(), UUID.randomUUID(), 0.0);
        BendableBigDecimalScore score = scoreCalculator.calculateScore(solution);
        Assertions.assertEquals((double)0.0, (double)score.getSoftScore(0).doubleValue(), (double)1.0E-5);
    }
}

