/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.lime.DatasetEncoder;
import org.kie.kogito.explainability.model.EncodingParams;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

class DatasetEncoderTest {
    DatasetEncoderTest() {
    }

    @Test
    void testEmptyDatasetEncoding() {
        LinkedList inputs = new LinkedList();
        LinkedList outputs = new LinkedList();
        LinkedList features = new LinkedList();
        Output originalOutput = new Output("foo", Type.NUMBER, new Value((Object)1), 1.0);
        EncodingParams params = new EncodingParams(1.0, 0.1);
        DatasetEncoder datasetEncoder = new DatasetEncoder(inputs, outputs, features, originalOutput, params);
        List trainingSet = datasetEncoder.getEncodedTrainingSet();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)trainingSet);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)trainingSet.isEmpty());
    }

    @Test
    void testDatasetEncodingWithBinaryData() {
        LinkedList<PredictionInput> perturbedInputs = new LinkedList<PredictionInput>();
        for (int i = 0; i < 10; ++i) {
            LinkedList<Feature> inputFeatures = new LinkedList<Feature>();
            for (int j = 0; j < 3; ++j) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(("" + i + j).getBytes(Charset.defaultCharset()));
                inputFeatures.add(TestUtils.getMockedFeature(Type.BINARY, new Value((Object)byteBuffer)));
            }
            perturbedInputs.add(new PredictionInput(inputFeatures));
        }
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (int i = 0; i < 3; ++i) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(("" + i + i).getBytes(Charset.defaultCharset()));
            features.add(TestUtils.getMockedFeature(Type.BINARY, new Value((Object)byteBuffer)));
        }
        PredictionInput originalInput = new PredictionInput(features);
        this.assertEncode(perturbedInputs, originalInput);
    }

    @Test
    void testDatasetEncodingWithVectorData() {
        LinkedList<PredictionInput> perturbedInputs = new LinkedList<PredictionInput>();
        for (int i = 0; i < 10; ++i) {
            LinkedList<Feature> inputFeatures = new LinkedList<Feature>();
            for (int j = 0; j < 3; ++j) {
                double[] doubles = new double[]{i, j};
                inputFeatures.add(TestUtils.getMockedFeature(Type.VECTOR, new Value((Object)doubles)));
            }
            perturbedInputs.add(new PredictionInput(inputFeatures));
        }
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (int i = 0; i < 3; ++i) {
            double[] doubles = new double[]{i, i};
            features.add(TestUtils.getMockedFeature(Type.BINARY, new Value((Object)doubles)));
        }
        PredictionInput originalInput = new PredictionInput(features);
        this.assertEncode(perturbedInputs, originalInput);
    }

    @Test
    void testDatasetEncodingWithCategoricalData() {
        LinkedList<PredictionInput> perturbedInputs = new LinkedList<PredictionInput>();
        for (int i = 0; i < 10; ++i) {
            LinkedList<Feature> inputFeatures = new LinkedList<Feature>();
            for (int j = 0; j < 3; ++j) {
                double[] doubles = new double[2];
                inputFeatures.add(TestUtils.getMockedFeature(Type.CATEGORICAL, new Value((Object)("" + i + j))));
            }
            perturbedInputs.add(new PredictionInput(inputFeatures));
        }
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (int i = 0; i < 3; ++i) {
            features.add(TestUtils.getMockedFeature(Type.CATEGORICAL, new Value((Object)("" + i + i))));
        }
        PredictionInput originalInput = new PredictionInput(features);
        this.assertEncode(perturbedInputs, originalInput);
    }

    @Test
    void testDatasetEncodingWithBooleanData() {
        LinkedList<PredictionInput> perturbedInputs = new LinkedList<PredictionInput>();
        for (int i = 0; i < 10; ++i) {
            LinkedList<Feature> inputFeatures = new LinkedList<Feature>();
            for (int j = 0; j < 3; ++j) {
                inputFeatures.add(TestUtils.getMockedFeature(Type.BOOLEAN, new Value((Object)(j % 2 == 0 ? 1 : 0))));
            }
            perturbedInputs.add(new PredictionInput(inputFeatures));
        }
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (int i = 0; i < 3; ++i) {
            features.add(TestUtils.getMockedFeature(Type.BOOLEAN, new Value((Object)(i % 2 == 0 ? 1 : 0))));
        }
        PredictionInput originalInput = new PredictionInput(features);
        this.assertEncode(perturbedInputs, originalInput);
    }

    @Test
    void testDatasetEncodingWithNumericData() {
        LinkedList<PredictionInput> perturbedInputs = new LinkedList<PredictionInput>();
        for (int i = 0; i < 10; ++i) {
            LinkedList<Feature> inputFeatures = new LinkedList<Feature>();
            for (int j = 0; j < 3; ++j) {
                inputFeatures.add(TestUtils.getMockedNumericFeature());
            }
            perturbedInputs.add(new PredictionInput(inputFeatures));
        }
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (int i = 0; i < 3; ++i) {
            features.add(TestUtils.getMockedNumericFeature());
        }
        PredictionInput originalInput = new PredictionInput(features);
        this.assertEncode(perturbedInputs, originalInput);
    }

    @Test
    void testDatasetEncodingWithTextData() {
        LinkedList<PredictionInput> perturbedInputs = new LinkedList<PredictionInput>();
        for (int i = 0; i < 10; ++i) {
            LinkedList<Feature> inputFeatures = new LinkedList<Feature>();
            for (int j = 0; j < 3; ++j) {
                inputFeatures.add(TestUtils.getMockedTextFeature(i + " " + j));
            }
            perturbedInputs.add(new PredictionInput(inputFeatures));
        }
        LinkedList<Feature> features = new LinkedList<Feature>();
        for (int i = 0; i < 3; ++i) {
            features.add(TestUtils.getMockedTextFeature(i + " " + i));
        }
        PredictionInput originalInput = new PredictionInput(features);
        this.assertEncode(perturbedInputs, originalInput);
    }

    private void assertEncode(List<PredictionInput> perturbedInputs, PredictionInput originalInput) {
        LinkedList<Output> outputs = new LinkedList<Output>();
        for (int i = 0; i < 10; ++i) {
            outputs.add(new Output("o", Type.NUMBER, new Value((Object)(i % 2 == 0 ? 1.0 : 0.0)), 1.0));
        }
        Output originalOutput = new Output("o", Type.BOOLEAN, new Value((Object)1.0), 1.0);
        EncodingParams params = new EncodingParams(1.0, 0.1);
        DatasetEncoder datasetEncoder = new DatasetEncoder(perturbedInputs, outputs, originalInput.getFeatures(), originalOutput, params);
        List trainingSet = datasetEncoder.getEncodedTrainingSet();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)trainingSet);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)trainingSet.size());
        for (Pair pair : trainingSet) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)pair.getKey());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)pair.getValue());
            Assertions.assertThat((Double)((Double)pair.getValue())).isBetween(Double.valueOf(0.0), Double.valueOf(1.0));
        }
    }
}

