/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.lime.HighScoreNumericFeatureZonesProvider;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.GenericFeatureDistribution;
import org.kie.kogito.explainability.model.IndependentFeaturesDataDistribution;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

class HighScoreNumericFeatureZonesProviderTest {
    HighScoreNumericFeatureZonesProviderTest() {
    }

    @Test
    void testEmptyData() {
        ArrayList features = new ArrayList();
        PredictionProvider predictionProvider = TestUtils.getSumThresholdModel(0.1, 0.1);
        ArrayList featureDistributions = new ArrayList();
        IndependentFeaturesDataDistribution dataDistribution = new IndependentFeaturesDataDistribution(featureDistributions);
        Map highScoreFeatureZones = HighScoreNumericFeatureZonesProvider.getHighScoreFeatureZones((DataDistribution)dataDistribution, (PredictionProvider)predictionProvider, features, (int)10);
        AssertionsForClassTypes.assertThat((Object)highScoreFeatureZones).isNotNull();
        AssertionsForClassTypes.assertThat((int)highScoreFeatureZones.size()).isZero();
    }

    @Test
    void testNonEmptyData() {
        Random random = new Random();
        random.setSeed(0L);
        PerturbationContext perturbationContext = new PerturbationContext(random, 1);
        ArrayList<Feature> features = new ArrayList<Feature>();
        PredictionProvider predictionProvider = TestUtils.getSumThresholdModel(0.1, 0.1);
        ArrayList<GenericFeatureDistribution> featureDistributions = new ArrayList<GenericFeatureDistribution>();
        int nf = 4;
        for (int i = 0; i < nf; ++i) {
            Feature numericalFeature = FeatureFactory.newNumericalFeature((String)("f-" + i), (Number)Double.NaN);
            features.add(numericalFeature);
            ArrayList<Value> values = new ArrayList<Value>();
            for (int r = 0; r < 4; ++r) {
                values.add(Type.NUMBER.randomValue(perturbationContext));
            }
            featureDistributions.add(new GenericFeatureDistribution(numericalFeature, values));
        }
        IndependentFeaturesDataDistribution dataDistribution = new IndependentFeaturesDataDistribution(featureDistributions);
        Map highScoreFeatureZones = HighScoreNumericFeatureZonesProvider.getHighScoreFeatureZones((DataDistribution)dataDistribution, (PredictionProvider)predictionProvider, features, (int)10);
        AssertionsForClassTypes.assertThat((Object)highScoreFeatureZones).isNotNull();
        AssertionsForClassTypes.assertThat((int)highScoreFeatureZones.size()).isEqualTo(4);
    }
}

