/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.EncodingParams;
import org.mockito.Mockito;

class LimeConfigTest {
    LimeConfigTest() {
    }

    @Test
    void testNumericEncodingParams() {
        LimeConfig config = new LimeConfig().withEncodingParams(new EncodingParams(0.01, 2.0));
        AssertionsForClassTypes.assertThat((double)config.getEncodingParams().getNumericTypeClusterGaussianFilterWidth()).isEqualTo(0.01);
        AssertionsForClassTypes.assertThat((double)config.getEncodingParams().getNumericTypeClusterThreshold()).isEqualTo(2.0);
    }

    @Test
    void testNormalizeWeights() {
        LimeConfig config = new LimeConfig().withNormalizeWeights(false);
        AssertionsForClassTypes.assertThat((boolean)config.isNormalizeWeights()).isFalse();
        config = new LimeConfig().withNormalizeWeights(true);
        AssertionsForClassTypes.assertThat((boolean)config.isNormalizeWeights()).isTrue();
        config = new LimeConfig();
        AssertionsForClassTypes.assertThat((boolean)config.isNormalizeWeights()).isTrue();
    }

    @Test
    void testBoostrapInputs() {
        LimeConfig config = new LimeConfig().witBootstrapInputs(10);
        AssertionsForClassTypes.assertThat((int)config.getBoostrapInputs()).isEqualTo(10);
    }

    @Test
    void testAdaptiveVariance() {
        LimeConfig config = new LimeConfig().withAdaptiveVariance(false);
        AssertionsForClassTypes.assertThat((boolean)config.isAdaptDatasetVariance()).isFalse();
        config = new LimeConfig().withAdaptiveVariance(true);
        AssertionsForClassTypes.assertThat((boolean)config.isAdaptDatasetVariance()).isTrue();
    }

    @Test
    void testDataDistribution() {
        DataDistribution dd = (DataDistribution)Mockito.mock(DataDistribution.class);
        LimeConfig config = new LimeConfig().withDataDistribution(dd);
        AssertionsForClassTypes.assertThat((Object)config.getDataDistribution()).isEqualTo((Object)dd);
    }

    @Test
    void testHighScoreFeatureZones() {
        LimeConfig config = new LimeConfig().withHighScoreFeatureZones(false);
        AssertionsForClassTypes.assertThat((boolean)config.isHighScoreFeatureZones()).isFalse();
        config = new LimeConfig().withHighScoreFeatureZones(true);
        AssertionsForClassTypes.assertThat((boolean)config.isHighScoreFeatureZones()).isTrue();
    }

    @Test
    void testPenalizeBalanceSparse() {
        LimeConfig config = new LimeConfig().withPenalizeBalanceSparse(false);
        AssertionsForClassTypes.assertThat((boolean)config.isPenalizeBalanceSparse()).isFalse();
        config = new LimeConfig().withPenalizeBalanceSparse(true);
        AssertionsForClassTypes.assertThat((boolean)config.isPenalizeBalanceSparse()).isTrue();
    }

    @Test
    void testRetries() {
        LimeConfig config = new LimeConfig().withRetries(5);
        AssertionsForClassTypes.assertThat((int)config.getNoOfRetries()).isEqualTo(5);
    }

    @Test
    void testProximityFilter() {
        LimeConfig config = new LimeConfig().withProximityFilter(false);
        AssertionsForClassTypes.assertThat((boolean)config.isProximityFilter()).isFalse();
        config = new LimeConfig().withProximityFilter(true);
        AssertionsForClassTypes.assertThat((boolean)config.isProximityFilter()).isTrue();
    }

    @Test
    void testEquals() {
        LimeConfig c1 = new LimeConfig();
        LimeConfig c1Copy = c1.copy();
        LimeConfig c2 = new LimeConfig();
        LimeConfig c3 = new LimeConfig().withHighScoreFeatureZones(false);
        AssertionsForClassTypes.assertThat((Object)c1).isEqualTo((Object)c1Copy);
        AssertionsForClassTypes.assertThat((Object)c1).isNotEqualTo((Object)c2);
        AssertionsForClassTypes.assertThat((Object)c1).isNotEqualTo(null);
        AssertionsForClassTypes.assertThat((Object)c1).isNotEqualTo((Object)c3);
    }
}

