/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.optim.LimeCombinedScoreCalculator;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigEntityFactory;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigSolution;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.SimplePrediction;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;

class LimeCombinedScoreCalculatorTest {
    LimeCombinedScoreCalculatorTest() {
    }

    @Test
    void testScoreWithEmptyPredictions() {
        LimeCombinedScoreCalculator scoreCalculator = new LimeCombinedScoreCalculator();
        LimeConfig config = new LimeConfig();
        List predictions = Collections.emptyList();
        List entities = Collections.emptyList();
        PredictionProvider model = TestUtils.getDummyTextClassifier();
        LimeConfigSolution solution = new LimeConfigSolution(config, predictions, entities, model);
        SimpleBigDecimalScore score = scoreCalculator.calculateScore(solution);
        AssertionsForClassTypes.assertThat((Object)score).isNotNull();
        ((AbstractBigDecimalAssert)AssertionsForClassTypes.assertThat((BigDecimal)score.getScore()).isNotNull()).isEqualTo((Object)BigDecimal.valueOf(0L));
    }

    @Test
    void testNonZeroScore() throws ExecutionException, InterruptedException, TimeoutException {
        PredictionProvider model = TestUtils.getDummyTextClassifier();
        LimeCombinedScoreCalculator scoreCalculator = new LimeCombinedScoreCalculator();
        LimeConfig config = new LimeConfig();
        List<Feature> features = List.of(FeatureFactory.newFulltextFeature((String)"text", (String)"money so they say is the root of all evil today"));
        PredictionInput input = new PredictionInput(features);
        List predictionOutputs = (List)model.predictAsync(List.of(input)).get(5L, Config.DEFAULT_ASYNC_TIMEUNIT);
        AssertionsForClassTypes.assertThat((Object)predictionOutputs).isNotNull();
        AssertionsForClassTypes.assertThat((int)predictionOutputs.size()).isEqualTo(1);
        PredictionOutput output = (PredictionOutput)predictionOutputs.get(0);
        SimplePrediction prediction = new SimplePrediction(input, output);
        List<SimplePrediction> predictions = List.of(prediction);
        List entities = LimeConfigEntityFactory.createEncodingEntities((LimeConfig)config);
        LimeConfigSolution solution = new LimeConfigSolution(config, predictions, entities, model);
        SimpleBigDecimalScore score = scoreCalculator.calculateScore(solution);
        AssertionsForClassTypes.assertThat((Object)score).isNotNull();
        ((AbstractBigDecimalAssert)AssertionsForClassTypes.assertThat((BigDecimal)score.getScore()).isNotNull()).isNotEqualTo((Object)BigDecimal.valueOf(0L));
    }
}

