/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import org.kie.kogito.explainability.local.counterfactual.entities.AbstractAlgebraicEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

public abstract class AbstractNumericEntity<T extends Number>
extends AbstractAlgebraicEntity<T> {
    protected Double stdDev;

    protected AbstractNumericEntity() {
    }

    protected AbstractNumericEntity(T originalValue, String featureName, T minimum, T maximum, FeatureDistribution featureDistribution, boolean constrained) {
        super(originalValue, featureName, minimum, maximum, constrained);
        this.range = ((Number)maximum).doubleValue() - ((Number)minimum).doubleValue();
        if (featureDistribution != null) {
            double[] samples = featureDistribution.getAllSamples().stream().mapToDouble(Value::asNumber).toArray();
            double mean = DataUtils.getMean(samples);
            this.stdDev = DataUtils.getStdDev(samples, mean);
        }
    }

    @Override
    public double distance() {
        double distance = Math.abs(((Number)this.proposedValue).doubleValue() - ((Number)this.originalValue).doubleValue());
        if (this.stdDev != null) {
            return distance / (this.stdDev * this.stdDev);
        }
        return distance;
    }

    @Override
    public double similarity() {
        return 1.0 - Math.abs(((Number)this.proposedValue).doubleValue() - ((Number)this.originalValue).doubleValue()) / this.range;
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newNumericalFeature(this.featureName, (Number)this.proposedValue);
    }
}

