/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.Currency;
import java.util.Set;
import org.kie.kogito.explainability.local.counterfactual.entities.AbstractCategoricalEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class CurrencyEntity
extends AbstractCategoricalEntity<Currency> {
    public CurrencyEntity() {
    }

    private CurrencyEntity(Currency originalValue, String featureName, Set<Currency> allowedCategories, boolean constrained) {
        super(originalValue, featureName, allowedCategories, constrained);
    }

    public static CurrencyEntity from(Feature originalFeature, Set<Currency> categories, boolean constrained) {
        return new CurrencyEntity((Currency)originalFeature.getValue().getUnderlyingObject(), originalFeature.getName(), categories, constrained);
    }

    public static CurrencyEntity from(Feature originalFeature, Set<Currency> categories) {
        return CurrencyEntity.from(originalFeature, categories, false);
    }

    @Override
    @ValueRangeProvider(id="categoricalRange")
    public Set<Currency> getValueRange() {
        return this.allowedCategories;
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newCurrencyFeature(this.featureName, (Currency)this.proposedValue);
    }

    @Override
    @PlanningVariable(valueRangeProviderRefs={"categoricalRange"})
    public Currency getProposedValue() {
        return (Currency)this.proposedValue;
    }

    @Override
    public void setProposedValue(Currency proposedValue) {
        this.proposedValue = proposedValue;
    }
}

