/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.shap;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.math3.linear.RealVector;
import org.kie.kogito.explainability.model.FeatureImportance;
import org.kie.kogito.explainability.model.Saliency;

public class ShapResults {
    private final Saliency[] saliencies;
    private final RealVector fnull;

    public ShapResults(Saliency[] saliencies, RealVector fnull) {
        this.saliencies = saliencies;
        this.fnull = fnull;
    }

    public Saliency[] getSaliencies() {
        return this.saliencies;
    }

    public RealVector getFnull() {
        return this.fnull;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapResults other = (ShapResults)o;
        if (this.saliencies.length != other.getSaliencies().length) {
            return false;
        }
        if (!this.fnull.equals((Object)other.getFnull())) {
            return false;
        }
        for (int i = 0; i < this.saliencies.length; ++i) {
            List<FeatureImportance> thisPFIs = this.saliencies[i].getPerFeatureImportance();
            List<FeatureImportance> otherPFIs = other.getSaliencies()[i].getPerFeatureImportance();
            if (thisPFIs.size() != otherPFIs.size()) {
                return false;
            }
            for (int j = 0; j < thisPFIs.size(); ++j) {
                if (thisPFIs.get(j).equals(otherPFIs.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.saliencies), this.fnull);
    }
}

