/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.model.Value;

class ValueTest {
    ValueTest() {
    }

    @Test
    void testNumericValue() {
        Value numericValue = new Value((Object)1.1);
        Assertions.assertNotNull((Object)numericValue.getUnderlyingObject());
        Assertions.assertEquals((double)1.1, (Double)((Double)numericValue.getUnderlyingObject()));
        Assertions.assertNotNull((Object)numericValue.asString());
        Assertions.assertEquals((Object)"1.1", (Object)numericValue.asString());
        Assertions.assertEquals((double)1.1, (double)numericValue.asNumber());
        double[] vector = numericValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])new double[]{1.1}, (double[])vector);
    }

    @Test
    void testVectorValue() {
        double[] doubles = new double[]{0.1, 0.2, 0.3};
        Value vectorValue = new Value((Object)doubles);
        Assertions.assertNotNull((Object)vectorValue.getUnderlyingObject());
        Assertions.assertEquals((Object)doubles, (Object)vectorValue.getUnderlyingObject());
        Assertions.assertNotNull((Object)vectorValue.asString());
        Assertions.assertEquals((Object)"{0.1,0.2,0.3}", (Object)vectorValue.asString());
        Assertions.assertEquals((double)Double.NaN, (double)vectorValue.asNumber());
        double[] vector = vectorValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])doubles, (double[])vector);
    }

    @Test
    void testVectorStringValue() {
        double[] doubles = new double[]{0.1, 0.2, 0.3};
        String vectorString = Arrays.toString(doubles);
        Value vectorValue = new Value((Object)vectorString);
        Assertions.assertNotNull((Object)vectorValue.getUnderlyingObject());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.getUnderlyingObject());
        Assertions.assertNotNull((Object)vectorValue.asString());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.asString());
        Assertions.assertEquals((double)Double.NaN, (double)vectorValue.asNumber());
        double[] vector = vectorValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])doubles, (double[])vector);
    }

    @Test
    void testVectorBytesValue() {
        double[] doubles = new double[]{0.1, 0.2, 0.3};
        String vectorString = Arrays.toString(doubles);
        ByteBuffer byteBuffer = ByteBuffer.wrap(vectorString.getBytes());
        Value vectorValue = new Value((Object)byteBuffer);
        Assertions.assertNotNull((Object)vectorValue.getUnderlyingObject());
        Assertions.assertEquals((Object)byteBuffer, (Object)vectorValue.getUnderlyingObject());
        Assertions.assertNotNull((Object)vectorValue.asString());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.asString());
        Assertions.assertEquals((double)Double.NaN, (double)vectorValue.asNumber());
        double[] vector = vectorValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])doubles, (double[])vector);
    }

    @Test
    void testStringVectorValue() {
        String vectorString = "0.1 0.2 0.3";
        Value vectorValue = new Value((Object)vectorString);
        Assertions.assertNotNull((Object)vectorValue.getUnderlyingObject());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.getUnderlyingObject());
        Assertions.assertNotNull((Object)vectorValue.asString());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.asString());
        Assertions.assertEquals((double)Double.NaN, (double)vectorValue.asNumber());
        double[] vector = vectorValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])new double[]{0.1, 0.2, 0.3}, (double[])vector);
    }

    @Test
    void testStringVectorValueWithTabs() {
        String vectorString = "0.1  0.2 0.3";
        Value vectorValue = new Value((Object)vectorString);
        Assertions.assertNotNull((Object)vectorValue.getUnderlyingObject());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.getUnderlyingObject());
        Assertions.assertNotNull((Object)vectorValue.asString());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.asString());
        Assertions.assertEquals((double)Double.NaN, (double)vectorValue.asNumber());
        double[] vector = vectorValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])new double[]{0.1, 0.2, 0.3}, (double[])vector);
    }
}

