/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Objects;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

public class Output {
    private final Value value;
    private final Type type;
    private final double score;
    private final String name;

    public Output(String name, Type type) {
        this(name, type, new Value<Object>(null), 0.0);
    }

    public Output(String name, Type type, Value value, double score) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.score = score;
    }

    public String getName() {
        return this.name;
    }

    public double getScore() {
        return this.score;
    }

    public Type getType() {
        return this.type;
    }

    public Value getValue() {
        return this.value;
    }

    public String toString() {
        return "Output{value=" + this.value + ", type=" + this.type + ", score=" + this.score + ", name='" + this.name + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Output output = (Output)o;
        return Double.compare(output.score, this.score) == 0 && Objects.equals(this.value, output.value) && this.type == output.type && Objects.equals(this.name, output.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type, this.score, this.name});
    }
}

