/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.GenericFeatureDistribution;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

public class PredictionInputsDataDistribution
implements DataDistribution {
    private final List<PredictionInput> inputs;
    private final Random random;

    public PredictionInputsDataDistribution(List<PredictionInput> inputs) {
        this(inputs, new SecureRandom());
    }

    public PredictionInputsDataDistribution(List<PredictionInput> inputs, Random random) {
        this.inputs = Collections.unmodifiableList(inputs);
        this.random = random;
    }

    @Override
    public PredictionInput sample() {
        if (this.inputs.isEmpty()) {
            return new PredictionInput(Collections.emptyList());
        }
        List<PredictionInput> inputs = this.sample(1);
        if (inputs.isEmpty()) {
            return new PredictionInput(Collections.emptyList());
        }
        return inputs.get(0);
    }

    @Override
    public List<PredictionInput> sample(int sampleSize) {
        return DataUtils.sampleWithReplacement(this.inputs, sampleSize, this.random);
    }

    @Override
    public List<PredictionInput> getAllSamples() {
        ArrayList<PredictionInput> copy = new ArrayList<PredictionInput>(this.inputs);
        Collections.shuffle(copy);
        return copy;
    }

    @Override
    public List<FeatureDistribution> asFeatureDistributions() {
        if (this.inputs.isEmpty()) {
            return Collections.emptyList();
        }
        PredictionInput firstInput = this.inputs.get(0);
        int shape = firstInput.getFeatures().size();
        ArrayList<FeatureDistribution> featureDistributions = new ArrayList<FeatureDistribution>(shape);
        for (int i = 0; i < shape; ++i) {
            Feature firstInputIthfeature = firstInput.getFeatures().get(i);
            ArrayList values = new ArrayList(this.inputs.size());
            for (PredictionInput input : this.inputs) {
                values.add(input.getFeatures().get(i).getValue());
            }
            Feature feature = FeatureFactory.copyOf(firstInputIthfeature, new Value<Object>(null));
            featureDistributions.add(new GenericFeatureDistribution(feature, values));
        }
        return featureDistributions;
    }
}

