/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.utils.ExplainabilityMetrics;
import org.kie.kogito.explainability.utils.LocalSaliencyStability;

public class ValidationUtils {
    public static void validateLocalSaliencyStability(PredictionProvider model, Prediction prediction, LocalExplainer<Map<String, Saliency>> explainer, int topK, double minimumPositiveStabilityScore, double minimumNegativeStabilityScore) throws ValidationException, InterruptedException, ExecutionException, TimeoutException {
        LocalSaliencyStability stability = ExplainabilityMetrics.getLocalSaliencyStability(model, prediction, explainer, topK, 10);
        for (int i = 1; i <= topK; ++i) {
            for (String decision : stability.getDecisions()) {
                double positiveStabilityScore = stability.getPositiveStabilityScore(decision, i);
                double negativeStabilityScore = stability.getNegativeStabilityScore(decision, i);
                if (positiveStabilityScore < minimumPositiveStabilityScore) {
                    throw new ValidationException("Expected positive stability score bigger than " + minimumPositiveStabilityScore + ". Got:" + positiveStabilityScore + " for " + decision + "@k=" + i);
                }
                if (!(negativeStabilityScore < minimumNegativeStabilityScore)) continue;
                throw new ValidationException("Expected negative stability score bigger than " + minimumNegativeStabilityScore + ". Got:" + negativeStabilityScore + " for " + decision + "@k=" + i);
            }
        }
    }

    public static class ValidationException
    extends Exception {
        public ValidationException(String message) {
            super(message);
        }
    }
}

