/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.local.counterfactual.entities.BinaryEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.local.counterfactual.entities.CurrencyEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DurationEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.LongEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.ObjectEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.TimeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.URIEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBinaryEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCompositeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCurrencyEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDurationEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedIntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedLongEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedObjectEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedTextEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedTimeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedURIEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedVectorEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.NumericFeatureDistribution;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.domain.BinaryFeatureDomain;
import org.kie.kogito.explainability.model.domain.CategoricalFeatureDomain;
import org.kie.kogito.explainability.model.domain.CurrencyFeatureDomain;
import org.kie.kogito.explainability.model.domain.DurationFeatureDomain;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;
import org.kie.kogito.explainability.model.domain.ObjectFeatureDomain;
import org.kie.kogito.explainability.model.domain.TimeFeatureDomain;
import org.kie.kogito.explainability.model.domain.URIFeatureDomain;

class CounterfactualEntityFactoryTest {
    CounterfactualEntityFactoryTest() {
    }

    @Test
    void testIntegerFactory() {
        int value = 5;
        FeatureDomain domain = NumericalFeatureDomain.create((double)0.0, (double)10.0);
        Feature feature = FeatureFactory.newNumericalFeature((String)"int-feature", (Number)5, (FeatureDomain)domain);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof IntegerEntity));
        Assertions.assertEquals((double)5.0, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testFixedIntegerFactory() {
        int value = 5;
        Feature feature = FeatureFactory.newNumericalFeature((String)"int-feature", (Number)5);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedIntegerEntity));
        Assertions.assertEquals((double)5.0, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testLongFactory() {
        long value = 5L;
        FeatureDomain domain = NumericalFeatureDomain.create((double)0.0, (double)10.0);
        Feature feature = FeatureFactory.newNumericalFeature((String)"long-feature", (Number)5L, (FeatureDomain)domain);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertNotNull((Object)counterfactualEntity);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof LongEntity));
        Assertions.assertEquals((double)5.0, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testFixedLongFactory() {
        long value = 5L;
        Feature feature = FeatureFactory.newNumericalFeature((String)"long-feature", (Number)5L);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertNotNull((Object)counterfactualEntity);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedLongEntity));
        Assertions.assertEquals((double)5.0, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testDoubleFactory() {
        double value = 5.5;
        FeatureDomain domain = NumericalFeatureDomain.create((double)0.0, (double)10.0);
        Feature feature = FeatureFactory.newNumericalFeature((String)"double-feature", (Number)5.5, (FeatureDomain)domain);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof DoubleEntity));
        Assertions.assertEquals((double)5.5, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testFixedDoubleFactory() {
        double value = 5.5;
        Feature feature = FeatureFactory.newNumericalFeature((String)"double-feature", (Number)5.5);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedDoubleEntity));
        Assertions.assertEquals((double)5.5, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testBooleanFactory() {
        boolean value = false;
        Feature feature = FeatureFactory.newBooleanFeature((String)"bool-feature", (Boolean)false, (FeatureDomain)EmptyFeatureDomain.create());
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof BooleanEntity));
        Assertions.assertEquals((Object)false, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
    }

    @Test
    void testFixedBooleanFactory() {
        boolean value = false;
        Feature feature = FeatureFactory.newBooleanFeature((String)"bool-feature", (Boolean)false);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedBooleanEntity));
        Assertions.assertEquals((Object)false, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
    }

    @Test
    void testCategoricalFactoryObject() {
        String value = "foo";
        FeatureDomain domain = CategoricalFeatureDomain.create((String[])new String[]{"foo", "bar"});
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo", (FeatureDomain)domain);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CategoricalEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CategoricalEntity)counterfactualEntity).getValueRange());
        Assertions.assertEquals((Object)"foo", (Object)counterfactualEntity.asFeature().getValue().toString());
    }

    @Test
    void testFixedCategoricalEntity() {
        String value = "foo";
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo");
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedCategoricalEntity));
        Assertions.assertEquals((Object)"foo", (Object)counterfactualEntity.asFeature().getValue().toString());
    }

    @Test
    void testCategoricalFactorySet() {
        String value = "foo";
        FeatureDomain domain = CategoricalFeatureDomain.create(Set.of("foo", "bar"));
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo", (FeatureDomain)domain);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CategoricalEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CategoricalEntity)counterfactualEntity).getValueRange());
        Assertions.assertEquals((Object)"foo", (Object)counterfactualEntity.asFeature().getValue().toString());
    }

    @Test
    void testCategoricalFactoryList() {
        String value = "foo";
        FeatureDomain domain = CategoricalFeatureDomain.create(List.of("foo", "bar"));
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo", (FeatureDomain)domain);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CategoricalEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CategoricalEntity)counterfactualEntity).getValueRange());
        Assertions.assertEquals((Object)"foo", (Object)counterfactualEntity.asFeature().getValue().toString());
    }

    @Test
    void testBinaryFactory() {
        ByteBuffer value = ByteBuffer.allocate(256);
        Feature feature = FeatureFactory.newBinaryFeature((String)"binary-feature", (ByteBuffer)value);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedBinaryEntity));
        Assertions.assertEquals((Object)Type.BINARY, (Object)counterfactualEntity.asFeature().getType());
        List categories = Stream.of("bar".getBytes(), "baz".getBytes(), "fun".getBytes()).map(ByteBuffer::wrap).collect(Collectors.toList());
        FeatureDomain domain = BinaryFeatureDomain.create(categories);
        feature = FeatureFactory.newBinaryFeature((String)"binary-feature", (ByteBuffer)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof BinaryEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((BinaryEntity)counterfactualEntity).getValueRange());
        domain = BinaryFeatureDomain.create(new HashSet(categories));
        feature = FeatureFactory.newBinaryFeature((String)"binary-feature", (ByteBuffer)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((BinaryEntity)counterfactualEntity).getValueRange());
        domain = BinaryFeatureDomain.create((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap("bar".getBytes()), ByteBuffer.wrap("baz".getBytes()), ByteBuffer.wrap("fun".getBytes())});
        feature = FeatureFactory.newBinaryFeature((String)"binary-feature", (ByteBuffer)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((BinaryEntity)counterfactualEntity).getValueRange());
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
    }

    @Test
    void testCompositeFactory() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newObjectFeature((String)"f1", (Object)new Object()));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)"hola"));
        features.add(FeatureFactory.newFulltextFeature((String)"f3", (String)"foo bar"));
        features.add(FeatureFactory.newNumericalFeature((String)"f4", (Number)131));
        features.add(FeatureFactory.newBooleanFeature((String)"f5", (Boolean)false));
        features.add(FeatureFactory.newDurationFeature((String)"f6", (Duration)Duration.ofDays(2L)));
        HashMap<String, Object> nestedMap = new HashMap<String, Object>();
        nestedMap.put("nf-1", "nested text");
        nestedMap.put("nf-2", ByteBuffer.allocate(1024));
        features.add(FeatureFactory.newCompositeFeature((String)"f7", nestedMap));
        for (Feature f : features) {
            map.put(f.getName(), f.getValue().getUnderlyingObject());
        }
        Feature feature = FeatureFactory.newCompositeFeature((String)"composite-feature", map);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedCompositeEntity));
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)counterfactualEntity.asFeature().getType());
    }

    @Test
    void testCurrencyFactory() {
        Currency value = Currency.getInstance(Locale.ITALY);
        Feature feature = FeatureFactory.newCurrencyFeature((String)"currrency-feature", (Currency)value);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedCurrencyEntity));
        Assertions.assertEquals((Object)Type.CURRENCY, (Object)counterfactualEntity.asFeature().getType());
        Feature fixedFeature = FeatureFactory.newCurrencyFeature((String)"currrency-feature", (Currency)value);
        FeatureDomain domain = CurrencyFeatureDomain.create(Currency.getAvailableCurrencies());
        feature = FeatureFactory.newCurrencyFeature((String)"currrency-feature", (Currency)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CurrencyEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CurrencyEntity)counterfactualEntity).getValueRange());
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
        domain = CurrencyFeatureDomain.create(new ArrayList<Currency>(Currency.getAvailableCurrencies()));
        feature = FeatureFactory.newCurrencyFeature((String)"currrency-feature", (Currency)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CurrencyEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CurrencyEntity)counterfactualEntity).getValueRange());
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
        Currency[] currencies = List.of(Locale.ITALY, Locale.UK, Locale.US).stream().map(Currency::getInstance).collect(Collectors.toList()).toArray(new Currency[0]);
        domain = CurrencyFeatureDomain.create((Currency[])currencies);
        feature = FeatureFactory.newCurrencyFeature((String)"currrency-feature", (Currency)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CurrencyEntity));
        Assertions.assertEquals((int)currencies.length, (int)((CurrencyEntity)counterfactualEntity).getValueRange().size());
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
    }

    @Test
    void testDurationFactory() {
        Duration value = Duration.ofDays(1L);
        Feature feature = FeatureFactory.newDurationFeature((String)"duration-feature", (Duration)value);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedDurationEntity));
        Assertions.assertEquals((Object)Type.DURATION, (Object)counterfactualEntity.asFeature().getType());
        FeatureDomain domain = DurationFeatureDomain.create((double)0.0, (double)60.0, (TemporalUnit)ChronoUnit.SECONDS);
        feature = FeatureFactory.newDurationFeature((String)"duration-feature", (Duration)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof DurationEntity));
        Assertions.assertEquals((Object)Type.DURATION, (Object)counterfactualEntity.asFeature().getType());
        Assertions.assertFalse((boolean)counterfactualEntity.isConstrained());
        DurationEntity entity = DurationEntity.from((Feature)feature, (Duration)Duration.ZERO, (Duration)Duration.ofDays(2L));
        Assertions.assertEquals((double)0.0, (double)entity.distance());
        Assertions.assertTrue((boolean)entity.getValueRange().contains((Object)100000.0));
        Assertions.assertFalse((boolean)entity.getValueRange().contains((Object)200000.0));
        Assertions.assertFalse((boolean)entity.isConstrained());
        entity = DurationEntity.from((Feature)feature, (Duration)Duration.ZERO, (Duration)Duration.ofDays(2L), (boolean)false);
        Assertions.assertEquals((double)0.0, (double)entity.distance());
        Assertions.assertFalse((boolean)entity.isConstrained());
        NumericFeatureDistribution distribution = new NumericFeatureDistribution(feature, new Random().doubles(10L).toArray());
        entity = DurationEntity.from((Feature)feature, (Duration)Duration.ZERO, (Duration)Duration.ofDays(2L), (FeatureDistribution)distribution);
        Assertions.assertEquals((double)0.0, (double)entity.distance());
        Assertions.assertFalse((boolean)entity.isConstrained());
    }

    @Test
    void testTextFactory() {
        String value = "foo";
        Feature feature = FeatureFactory.newTextFeature((String)"text-feature", (String)"foo");
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedTextEntity));
        Assertions.assertEquals((Object)Type.TEXT, (Object)counterfactualEntity.asFeature().getType());
        Feature varyingFeature = FeatureFactory.newTextFeature((String)"text-feature", (String)"foo", (FeatureDomain)EmptyFeatureDomain.create());
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CounterfactualEntityFactory.from((Feature)varyingFeature));
        Assertions.assertEquals((Object)"Unsupported feature type: text", (Object)exception.getMessage());
    }

    @Test
    void testTimeFactory() {
        LocalTime value = LocalTime.now();
        Feature feature = FeatureFactory.newTimeFeature((String)"time-feature", (LocalTime)value);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedTimeEntity));
        Assertions.assertEquals((Object)Type.TIME, (Object)counterfactualEntity.asFeature().getType());
        FeatureDomain domain = TimeFeatureDomain.create((LocalTime)value.minusHours(10L), (LocalTime)value.plusHours(10L));
        feature = FeatureFactory.newTimeFeature((String)"time-feature", (LocalTime)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof TimeEntity));
        Assertions.assertEquals((Object)Type.TIME, (Object)counterfactualEntity.asFeature().getType());
        Assertions.assertEquals((Object)value, (Object)((TimeEntity)counterfactualEntity).getProposedValue());
    }

    @Test
    void testURIFactory() throws URISyntaxException {
        URI value = URI.create("./");
        Feature feature = FeatureFactory.newURIFeature((String)"uri-feature", (URI)value);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedURIEntity));
        Assertions.assertEquals((Object)Type.URI, (Object)counterfactualEntity.asFeature().getType());
        FeatureDomain domain = URIFeatureDomain.create((URI[])new URI[]{new URI("./"), new URI("../"), new URI("https://example.com")});
        feature = FeatureFactory.newURIFeature((String)"uri-feature", (URI)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof URIEntity));
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
        domain = URIFeatureDomain.create(List.of(new URI("./"), new URI("../"), new URI("https://example.com")));
        feature = FeatureFactory.newURIFeature((String)"uri-feature", (URI)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof URIEntity));
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
        domain = URIFeatureDomain.create(Set.of(new URI("./"), new URI("../"), new URI("https://example.com")));
        feature = FeatureFactory.newURIFeature((String)"uri-feature", (URI)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof URIEntity));
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
    }

    @Test
    void testObjectFactory() {
        URI value = URI.create("./");
        Feature feature = FeatureFactory.newObjectFeature((String)"f", (Object)value);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedObjectEntity));
        Assertions.assertEquals((Object)Type.UNDEFINED, (Object)counterfactualEntity.asFeature().getType());
        FeatureDomain domain = ObjectFeatureDomain.create((Object[])new Object[]{"test", 45L});
        feature = FeatureFactory.newObjectFeature((String)"uri-feature", (Object)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof ObjectEntity));
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
        domain = ObjectFeatureDomain.create(List.of("test", Long.valueOf(45L)));
        feature = FeatureFactory.newObjectFeature((String)"uri-feature", (Object)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof ObjectEntity));
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
        domain = ObjectFeatureDomain.create(Set.of("test", Long.valueOf(45L)));
        feature = FeatureFactory.newObjectFeature((String)"uri-feature", (Object)value, (FeatureDomain)domain);
        counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof ObjectEntity));
        Assertions.assertEquals((Object)value, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
    }

    @Test
    void testVectorFactory() {
        double[] value = new double[10];
        Arrays.fill(value, 1.0);
        Feature feature = FeatureFactory.newVectorFeature((String)"uri-feature", (double[])value);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedVectorEntity));
        Assertions.assertEquals((Object)Type.VECTOR, (Object)counterfactualEntity.asFeature().getType());
    }

    @Test
    void testCreateFixedEntities() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-num1", (Number)100.1));
        features.add(FeatureFactory.newNumericalFeature((String)"f-num2", (Number)100.2, (FeatureDomain)NumericalFeatureDomain.create((double)0.0, (double)1000.0)));
        features.add(FeatureFactory.newNumericalFeature((String)"f-num3", (Number)100.3));
        features.add(FeatureFactory.newNumericalFeature((String)"f-num4", (Number)100.4, (FeatureDomain)NumericalFeatureDomain.create((double)0.0, (double)1000.0)));
        PredictionInput input = new PredictionInput(features);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input);
        Assertions.assertTrue((boolean)(entities.get(0) instanceof FixedDoubleEntity));
        Assertions.assertTrue((boolean)(entities.get(1) instanceof DoubleEntity));
        Assertions.assertTrue((boolean)(entities.get(2) instanceof FixedDoubleEntity));
        Assertions.assertTrue((boolean)(entities.get(3) instanceof DoubleEntity));
        Assertions.assertEquals((double)100.1, (double)((CounterfactualEntity)entities.get(0)).asFeature().getValue().asNumber());
        Assertions.assertEquals((double)100.2, (double)((CounterfactualEntity)entities.get(1)).asFeature().getValue().asNumber());
        Assertions.assertEquals((double)100.3, (double)((CounterfactualEntity)entities.get(2)).asFeature().getValue().asNumber());
        Assertions.assertEquals((double)100.4, (double)((CounterfactualEntity)entities.get(3)).asFeature().getValue().asNumber());
        Assertions.assertTrue((boolean)((CounterfactualEntity)entities.get(0)).isConstrained());
        Assertions.assertFalse((boolean)((CounterfactualEntity)entities.get(1)).isConstrained());
        Assertions.assertTrue((boolean)((CounterfactualEntity)entities.get(2)).isConstrained());
        Assertions.assertFalse((boolean)((CounterfactualEntity)entities.get(3)).isConstrained());
    }

    @Test
    void testValidateNullNumericalFeature() {
        Feature feature = FeatureFactory.newNumericalFeature((String)"double-feature", null);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CounterfactualEntityFactory.from((Feature)feature));
        Assertions.assertEquals((Object)"Null numeric features are not supported in counterfactuals", (Object)exception.getMessage());
    }
}

