/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.local.counterfactual.entities.LongEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.NumericFeatureDistribution;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;

class LongEntityTest {
    LongEntityTest() {
    }

    @Test
    void distanceUnscaled() {
        FeatureDomain featureDomain = NumericalFeatureDomain.create((double)0.0, (double)100.0);
        Feature feature = FeatureFactory.newNumericalFeature((String)"feature-long", (Number)20L, (FeatureDomain)featureDomain);
        LongEntity entity = (LongEntity)CounterfactualEntityFactory.from((Feature)feature);
        entity.proposedValue = 40L;
        Assertions.assertEquals((double)20.0, (double)entity.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void distanceScaled(int seed) {
        Random random = new Random();
        random.setSeed(seed);
        FeatureDomain featureDomain = NumericalFeatureDomain.create((double)0.0, (double)100.0);
        Feature feature = FeatureFactory.newNumericalFeature((String)"feature-long", (Number)20L, (FeatureDomain)featureDomain);
        NumericFeatureDistribution featureDistribution = new NumericFeatureDistribution(feature, random.longs(5000L, 10L, 40L).mapToDouble(x -> x).toArray());
        LongEntity entity = (LongEntity)CounterfactualEntityFactory.from((Feature)feature, (FeatureDistribution)featureDistribution);
        entity.proposedValue = 40L;
        double distance = entity.distance();
        Assertions.assertTrue((distance > 0.2 && distance < 0.3 ? 1 : 0) != 0);
    }
}

