/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.explainability.local.counterfactual.entities.BinaryEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CurrencyEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DurationEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.LongEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.ObjectEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.TimeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.URIEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBinaryEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCompositeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCurrencyEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDurationEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedIntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedObjectEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedTextEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedTimeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedURIEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedVectorEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;

class SimilarityTest {
    private static double HIGHEST_SIMILARITY = 1.0;
    private static double LOWEST_SIMILARITY = 0.0;

    SimilarityTest() {
    }

    @Test
    void integerSimpleSimilarity() {
        int value = 20;
        IntegerEntity x = IntegerEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)20), (int)0, (int)100);
        x.setProposedValue(Integer.valueOf(29));
        double similarity1 = x.similarity();
        x.setProposedValue(Integer.valueOf(11));
        double similarity2 = x.similarity();
        Assertions.assertEquals((double)similarity1, (double)similarity2);
        Assertions.assertTrue((similarity1 > 0.9 ? 1 : 0) != 0);
    }

    @Test
    void doubleSimpleSimilarity() {
        double value = 500.0;
        DoubleEntity x = DoubleEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)500.0), (double)0.0, (double)1000.0);
        x.setProposedValue(Double.valueOf(590.0));
        double similarity1 = x.similarity();
        x.setProposedValue(Double.valueOf(410.0));
        double similarity2 = x.similarity();
        Assertions.assertEquals((double)similarity1, (double)similarity2);
        Assertions.assertTrue((similarity1 > 0.9 ? 1 : 0) != 0);
    }

    @Test
    void longSimpleSimilarity() {
        long value = 20L;
        LongEntity x = LongEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)20L), (long)0L, (long)100L);
        x.setProposedValue(Long.valueOf(29L));
        double similarity1 = x.similarity();
        x.setProposedValue(Long.valueOf(11L));
        double similarity2 = x.similarity();
        Assertions.assertEquals((double)similarity1, (double)similarity2);
        Assertions.assertTrue((similarity1 > 0.9 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void booleanSimpleSimilarity(int seed) {
        Random random = new Random(seed);
        boolean originalValue = random.nextBoolean();
        BooleanEntity x = BooleanEntity.from((Feature)FeatureFactory.newBooleanFeature((String)"x", (Boolean)originalValue));
        x.setProposedValue(Boolean.valueOf(!originalValue));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)1.0, (double)x.distance());
        x.setProposedValue(Boolean.valueOf(originalValue));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @Test
    void categoricalSimpleSimilarity() {
        String value = "foo";
        Set<String> categories = Set.of("foo", "bar", "baz");
        CategoricalEntity x = CategoricalEntity.from((Feature)FeatureFactory.newCategoricalFeature((String)"x", (String)"foo"), categories);
        x.setProposedValue("bar");
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)1.0, (double)x.distance());
        x.setProposedValue("baz");
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)1.0, (double)x.distance());
        x.setProposedValue("foo");
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @Test
    void uriSimpleSimilarity() throws URISyntaxException {
        URI value = new URI("https://kogito.kie.org/trustyai/");
        Set<URI> uris = Set.of(new URI("https://example.com/foo"), new URI("https://example.com/bar"));
        URIEntity x = URIEntity.from((Feature)FeatureFactory.newURIFeature((String)"uri", (URI)value), uris);
        x.setProposedValue(new URI("https://example.com/bar"));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)1.0, (double)x.distance());
        x.setProposedValue(new URI("https://example.com/baz"));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)1.0, (double)x.distance());
        x.setProposedValue(new URI("https://kogito.kie.org/trustyai/"));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @Test
    void currencySimpleSimilarity() {
        Currency value = Currency.getInstance("GBP");
        Set<Currency> categories = Set.of(Currency.getInstance("GBP"), Currency.getInstance("EUR"), Currency.getInstance("USD"));
        CurrencyEntity x = CurrencyEntity.from((Feature)FeatureFactory.newCurrencyFeature((String)"currency", (Currency)value), categories);
        x.setProposedValue(Currency.getInstance("EUR"));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)1.0, (double)x.distance());
        x.setProposedValue(Currency.getInstance("USD"));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)1.0, (double)x.distance());
        x.setProposedValue(Currency.getInstance("GBP"));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @Test
    void binarySimpleSimilarity() {
        ByteBuffer bytes = ByteBuffer.wrap("foo".getBytes());
        List categories = Stream.of("bar".getBytes(), "baz".getBytes(), "fun".getBytes()).map(ByteBuffer::wrap).collect(Collectors.toList());
        BinaryEntity x = BinaryEntity.from((Feature)FeatureFactory.newBinaryFeature((String)"f", (ByteBuffer)bytes), new HashSet(categories));
        x.setProposedValue((ByteBuffer)categories.get(0));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)1.0, (double)x.distance());
        x.setProposedValue((ByteBuffer)categories.get(1));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)1.0, (double)x.distance());
        x.setProposedValue(bytes);
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @Test
    void durationSimpleSimilarity() {
        Long days = 365L;
        Duration duration = Duration.ofDays(days);
        DurationEntity x = DurationEntity.from((Feature)FeatureFactory.newDurationFeature((String)"x", (Duration)duration), (Duration)Duration.ZERO, (Duration)Duration.ofDays(3L * days));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        x.setProposedValue(Duration.ofDays(2L * days));
        Assertions.assertEquals((double)0.6666, (double)x.similarity(), (double)0.001);
        Assertions.assertEquals((double)Math.abs(Duration.ofDays(days).minus(Duration.ofDays(2L * days)).getSeconds()), (double)x.distance());
        x.setProposedValue(Duration.ofDays(-days.longValue()));
        Assertions.assertEquals((double)0.333, (double)x.similarity(), (double)0.001);
        Assertions.assertEquals((double)Math.abs(Duration.ofDays(days).minus(Duration.ofDays(-days.longValue())).getSeconds()), (double)x.distance());
        x.setProposedValue(Duration.ofDays(days));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
        x.setProposedValue(Duration.ofSeconds(-5L));
        Assertions.assertEquals((double)0.6666, (double)x.similarity(), (double)0.001);
        Assertions.assertEquals((double)Math.abs(Duration.ofDays(days).minus(Duration.ofSeconds(-5L)).getSeconds()), (double)x.distance());
    }

    @Test
    void timeSimpleSimilarity() {
        LocalTime value = LocalTime.of(17, 17);
        TimeEntity x = TimeEntity.from((Feature)FeatureFactory.newTimeFeature((String)"x", (LocalTime)value), (LocalTime)LocalTime.of(10, 0), (LocalTime)LocalTime.of(21, 18));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        x.setProposedValue(LocalTime.of(17, 59));
        Assertions.assertEquals((double)0.938, (double)x.similarity(), (double)0.001);
        Assertions.assertEquals((double)2520.0, (double)x.distance());
        x.setProposedValue(LocalTime.of(9, 23));
        Assertions.assertEquals((double)0.3, (double)x.similarity(), (double)0.001);
        Assertions.assertEquals((double)28440.0, (double)x.distance());
        x.setProposedValue(value);
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @Test
    void objectSimpleSimilarity() {
        Long value = 20L;
        List<String> categories = List.of(Long.valueOf(30L), "test");
        ObjectEntity x = ObjectEntity.from((Feature)FeatureFactory.newObjectFeature((String)"f", (Object)value), new HashSet<String>(categories));
        x.setProposedValue((Object)categories.get(0));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        x.setProposedValue((Object)categories.get(1));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        x.setProposedValue((Object)20L);
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedIntegerSimilarity(int seed) {
        Random random = new Random(seed);
        int value = random.nextInt();
        FixedIntegerEntity x = FixedIntegerEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)value));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedDoubleSimilarity(int seed) {
        Random random = new Random(seed);
        double value = random.nextDouble();
        FixedDoubleEntity x = FixedDoubleEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)value));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedBooleanSimilarity(int seed) {
        Random random = new Random(seed);
        boolean value = random.nextBoolean();
        FixedBooleanEntity x = FixedBooleanEntity.from((Feature)FeatureFactory.newBooleanFeature((String)"x", (Boolean)value));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedBinarySimilarity(int seed) {
        byte[] bytes = RandomUtils.nextBytes((int)20);
        FixedBinaryEntity x = FixedBinaryEntity.from((Feature)FeatureFactory.newBinaryFeature((String)"x", (ByteBuffer)ByteBuffer.wrap(bytes)));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedCurrencySimilarity(int seed) {
        Random random = new Random(seed);
        Set<Currency> currenciesSet = Currency.getAvailableCurrencies();
        Currency[] currenciesArray = currenciesSet.toArray(new Currency[currenciesSet.size()]);
        int index = random.nextInt(currenciesArray.length);
        FixedCurrencyEntity x = FixedCurrencyEntity.from((Feature)FeatureFactory.newCurrencyFeature((String)"x", (Currency)currenciesArray[index]));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedDurationSimilarity(int seed) {
        Random random = new Random(seed);
        Duration duration = Duration.ofDays(Math.abs(random.nextLong()) % 1000L);
        FixedDurationEntity x = FixedDurationEntity.from((Feature)FeatureFactory.newDurationFeature((String)"x", (Duration)duration));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedTextSimilarity(int seed) {
        Random random = new Random(seed);
        String text = UUID.randomUUID().toString();
        FixedTextEntity x = FixedTextEntity.from((Feature)FeatureFactory.newTextFeature((String)"x", (String)text));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedObjectSimilarity(int seed) {
        Random random = new Random(seed);
        String text = UUID.randomUUID().toString();
        FixedObjectEntity x = FixedObjectEntity.from((Feature)FeatureFactory.newObjectFeature((String)"x", (Object)text));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedTimeSimilarity(int seed) {
        Random random = new Random(seed);
        LocalTime time = LocalTime.of(random.nextInt(23), random.nextInt(59));
        FixedTimeEntity x = FixedTimeEntity.from((Feature)FeatureFactory.newTimeFeature((String)"x", (LocalTime)time));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
        Assertions.assertEquals((double)0.0, (double)x.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedURISimilarity(int seed) throws URISyntaxException {
        Random random = new Random(seed);
        URI uri = new URI("https://" + RandomStringUtils.randomAlphabetic((int)10) + "." + RandomStringUtils.randomAlphabetic((int)3) + "/" + RandomStringUtils.randomAlphanumeric((int)10));
        FixedURIEntity x = FixedURIEntity.from((Feature)FeatureFactory.newURIFeature((String)"x", (URI)uri));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedVectorSimilarity(int seed) throws URISyntaxException {
        Random random = new Random(seed);
        int size = 1 + random.nextInt(100);
        double[] array = random.doubles(size, -1000.0, 1000.0).toArray();
        FixedVectorEntity x = FixedVectorEntity.from((Feature)FeatureFactory.newVectorFeature((String)"x", (double[])array));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @Test
    void fixedCompositeSimilarity() {
        ArrayList transactions = new ArrayList();
        HashMap<String, Object> t1 = new HashMap<String, Object>();
        t1.put("Card Type", "Prepaid");
        t1.put("Location", "Global");
        t1.put("Amount", 141);
        t1.put("Auth Code", "Denied");
        transactions.add(t1);
        HashMap<String, Object> t2 = new HashMap<String, Object>();
        t2.put("Card Type", "Debit");
        t2.put("Location", "Local");
        t2.put("Amount", 19);
        t2.put("Auth Code", "Approved");
        transactions.add(t2);
        HashMap map = new HashMap();
        map.put("Transactions", transactions);
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(FeatureFactory.newCompositeFeature((String)"context", map));
        FixedCompositeEntity x = FixedCompositeEntity.from((Feature)FeatureFactory.newCompositeFeature((String)"x", features));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @RepeatedTest(value=5)
    void fixedCategoricalSimilarity() {
        String value = UUID.randomUUID().toString();
        FixedCategoricalEntity x = FixedCategoricalEntity.from((Feature)FeatureFactory.newCategoricalFeature((String)"x", (String)value));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void constantRelativeSimilarityIntegerEntity(int seed) {
        int[] values;
        Random random = new Random(seed);
        int MAX_UPPER_BOUND_RANGE = 10000;
        values = new int[]{random.nextInt(1000), values[0] + random.nextInt(100), values[1] + random.nextInt(100)};
        int lowerBound = random.nextInt(values[0] - 1);
        int upperBound = values[2] + random.nextInt(10000) + 1;
        IntegerEntity x = IntegerEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)values[0]), (int)lowerBound, (int)upperBound);
        x.setProposedValue(Integer.valueOf(values[1]));
        double x_similarity1 = x.similarity();
        x.setProposedValue(Integer.valueOf(values[2]));
        double x_similarity2 = x.similarity();
        lowerBound = random.nextInt(values[0] - 1);
        upperBound = values[2] + random.nextInt(10000) + 1;
        IntegerEntity y = IntegerEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"y", (Number)values[0]), (int)lowerBound, (int)upperBound);
        y.setProposedValue(Integer.valueOf(values[1]));
        double y_similarity1 = y.similarity();
        y.setProposedValue(Integer.valueOf(values[2]));
        double y_similarity2 = y.similarity();
        Assertions.assertTrue((x_similarity1 > x_similarity2 ? 1 : 0) != 0);
        Assertions.assertTrue((y_similarity1 > y_similarity2 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void constantRelativeSimilarityDoubleEntity(int seed) {
        double[] values;
        Random random = new Random(seed);
        double MAX_UPPER_BOUND_RANGE = 10000.0;
        values = new double[]{random.nextDouble() * 1000.0, values[0] + random.nextDouble() * 100.0, values[1] + random.nextDouble() * 100.0};
        double lowerBound = random.nextDouble() * values[0];
        double upperBound = values[2] + random.nextDouble() * 10000.0;
        DoubleEntity x = DoubleEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)values[0]), (double)lowerBound, (double)upperBound);
        x.setProposedValue(Double.valueOf(values[1]));
        double x_similarity1 = x.similarity();
        x.setProposedValue(Double.valueOf(values[2]));
        double x_similarity2 = x.similarity();
        lowerBound = random.nextDouble() * values[0];
        upperBound = values[2] + random.nextDouble() * 10000.0;
        DoubleEntity y = DoubleEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"y", (Number)values[0]), (double)lowerBound, (double)upperBound);
        y.setProposedValue(Double.valueOf(values[1]));
        double y_similarity1 = y.similarity();
        y.setProposedValue(Double.valueOf(values[2]));
        double y_similarity2 = y.similarity();
        Assertions.assertTrue((x_similarity1 > x_similarity2 ? 1 : 0) != 0);
        Assertions.assertTrue((y_similarity1 > y_similarity2 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void constantRelativeSimilarityLongEntity(int seed) {
        long[] values;
        Random random = new Random(seed);
        int MAX_UPPER_BOUND_RANGE = 10000;
        values = new long[]{random.nextInt(1000), values[0] + (long)random.nextInt(100), values[1] + (long)random.nextInt(100)};
        long lowerBound = random.nextInt((int)values[0] - 1);
        long upperBound = values[2] + (long)random.nextInt(10000) + 1L;
        LongEntity x = LongEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)values[0]), (long)lowerBound, (long)upperBound);
        x.setProposedValue(Long.valueOf(values[1]));
        double x_similarity1 = x.similarity();
        x.setProposedValue(Long.valueOf(values[2]));
        double x_similarity2 = x.similarity();
        lowerBound = random.nextInt((int)values[0] - 1);
        upperBound = values[2] + (long)random.nextInt(10000) + 1L;
        LongEntity y = LongEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"y", (Number)values[0]), (long)lowerBound, (long)upperBound);
        y.setProposedValue(Long.valueOf(values[1]));
        double y_similarity1 = y.similarity();
        y.setProposedValue(Long.valueOf(values[2]));
        double y_similarity2 = y.similarity();
        Assertions.assertTrue((x_similarity1 > x_similarity2 ? 1 : 0) != 0);
        Assertions.assertTrue((y_similarity1 > y_similarity2 ? 1 : 0) != 0);
    }
}

