/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionInputsDataDistribution;

class PredictionInputsDataDistributionTest {
    PredictionInputsDataDistributionTest() {
    }

    @Test
    void testSample() {
        ArrayList<PredictionInput> inputs = new ArrayList<PredictionInput>(3);
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("foo"))));
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("bar"))));
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("asd"))));
        PredictionInputsDataDistribution predictionInputsDataDistribution = new PredictionInputsDataDistribution(inputs);
        PredictionInput sample = predictionInputsDataDistribution.sample();
        Assertions.assertNotNull((Object)sample);
        Assertions.assertTrue((boolean)inputs.contains(sample));
    }

    @Test
    void testSamples() {
        ArrayList<PredictionInput> inputs = new ArrayList<PredictionInput>(3);
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("foo"))));
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("bar"))));
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("asd"))));
        PredictionInputsDataDistribution predictionInputsDataDistribution = new PredictionInputsDataDistribution(inputs);
        Assertions.assertEquals((int)3, (int)predictionInputsDataDistribution.getAllSamples().size());
        List samples = predictionInputsDataDistribution.sample(2);
        Assertions.assertNotNull((Object)samples);
        Assertions.assertEquals((int)2, (int)samples.size());
        for (PredictionInput sample : samples) {
            Assertions.assertTrue((boolean)inputs.contains(sample));
        }
    }

    @Test
    void testLargerSamples() {
        ArrayList<PredictionInput> inputs = new ArrayList<PredictionInput>(3);
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("foo"))));
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("bar"))));
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("asd"))));
        PredictionInputsDataDistribution predictionInputsDataDistribution = new PredictionInputsDataDistribution(inputs);
        List samples = predictionInputsDataDistribution.sample(12);
        Assertions.assertNotNull((Object)samples);
        Assertions.assertEquals((int)12, (int)samples.size());
        for (PredictionInput sample : samples) {
            Assertions.assertTrue((boolean)inputs.contains(sample));
        }
    }

    @Test
    void testAsFeatureDistributions() {
        ArrayList<PredictionInput> inputs = new ArrayList<PredictionInput>(3);
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("foo"), TestUtils.getMockedNumericFeature())));
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("bar"), TestUtils.getMockedNumericFeature())));
        inputs.add(new PredictionInput(List.of(TestUtils.getMockedTextFeature("asd"), TestUtils.getMockedNumericFeature())));
        PredictionInputsDataDistribution predictionInputsDataDistribution = new PredictionInputsDataDistribution(inputs);
        List featureDistributions = predictionInputsDataDistribution.asFeatureDistributions();
        Assertions.assertNotNull((Object)featureDistributions);
        Assertions.assertEquals((int)2, (int)featureDistributions.size());
        for (FeatureDistribution featureDistribution : featureDistributions) {
            Assertions.assertNotNull((Object)featureDistribution.getFeature());
            List allSamples = featureDistribution.getAllSamples();
            Assertions.assertNotNull((Object)allSamples);
            Assertions.assertEquals((int)3, (int)allSamples.size());
        }
    }
}

