/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.Set;
import org.kie.kogito.explainability.local.counterfactual.entities.AbstractCategoricalEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class CategoricalEntity
extends AbstractCategoricalEntity<String> {
    public CategoricalEntity() {
    }

    private CategoricalEntity(String originalValue, String featureName, Set<String> allowedCategories, boolean constrained) {
        super(originalValue, featureName, allowedCategories, constrained);
    }

    public static CategoricalEntity from(Feature originalFeature, Set<String> categories, boolean constrained) {
        return new CategoricalEntity(originalFeature.getValue().asString(), originalFeature.getName(), categories, constrained);
    }

    public static CategoricalEntity from(Feature originalFeature, Set<String> categories) {
        return CategoricalEntity.from(originalFeature, categories, false);
    }

    @Override
    @ValueRangeProvider(id="categoricalRange")
    public Set<String> getValueRange() {
        return this.allowedCategories;
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newCategoricalFeature(this.featureName, (String)this.proposedValue);
    }

    @Override
    @PlanningVariable(valueRangeProviderRefs={"categoricalRange"})
    public String getProposedValue() {
        return (String)this.proposedValue;
    }

    @Override
    public void setProposedValue(String proposedValue) {
        this.proposedValue = proposedValue;
    }
}

