/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import org.kie.kogito.explainability.local.counterfactual.entities.AbstractNumericEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class DoubleEntity
extends AbstractNumericEntity<Double> {
    public DoubleEntity() {
    }

    private DoubleEntity(Double originalValue, String featureName, double minimum, double maximum, FeatureDistribution featureDistribution, boolean constrained) {
        super(originalValue, featureName, minimum, maximum, featureDistribution, constrained);
    }

    public static DoubleEntity from(Feature originalFeature, double minimum, double maximum, boolean constrained) {
        return DoubleEntity.from(originalFeature, minimum, maximum, null, constrained);
    }

    public static DoubleEntity from(Feature originalFeature, double minimum, double maximum, FeatureDistribution featureDistribution, boolean constrained) {
        return new DoubleEntity(originalFeature.getValue().asNumber(), originalFeature.getName(), minimum, maximum, featureDistribution, constrained);
    }

    public static DoubleEntity from(Feature originalFeature, double minimum, double maximum) {
        return DoubleEntity.from(originalFeature, minimum, maximum, null, false);
    }

    public static DoubleEntity from(Feature originalFeature, double minimum, double maximum, FeatureDistribution featureDistribution) {
        return DoubleEntity.from(originalFeature, minimum, maximum, featureDistribution, false);
    }

    @ValueRangeProvider(id="doubleRange")
    public ValueRange<Double> getValueRange() {
        return ValueRangeFactory.createDoubleValueRange((double)((Double)this.rangeMinimum), (double)((Double)this.rangeMaximum));
    }

    @PlanningVariable(valueRangeProviderRefs={"doubleRange"})
    public Double getProposedValue() {
        return (Double)this.proposedValue;
    }

    public void setProposedValue(Double proposedValue) {
        this.proposedValue = proposedValue;
    }
}

