/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import org.kie.kogito.explainability.local.counterfactual.entities.AbstractNumericEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class LongEntity
extends AbstractNumericEntity<Long> {
    public LongEntity() {
    }

    private LongEntity(Long originalValue, String featureName, long minimum, long maximum, FeatureDistribution featureDistribution, boolean constrained) {
        super(originalValue, featureName, minimum, maximum, featureDistribution, constrained);
    }

    public static LongEntity from(Feature originalFeature, long minimum, long maximum, boolean constrained) {
        return LongEntity.from(originalFeature, minimum, maximum, null, constrained);
    }

    public static LongEntity from(Feature originalFeature, long minimum, long maximum, FeatureDistribution featureDistribution, boolean constrained) {
        return new LongEntity((long)originalFeature.getValue().asNumber(), originalFeature.getName(), minimum, maximum, featureDistribution, constrained);
    }

    public static LongEntity from(Feature feature, long minimum, long maximum) {
        return LongEntity.from(feature, minimum, maximum, null, false);
    }

    public static LongEntity from(Feature feature, long minimum, long maximum, FeatureDistribution featureDistribution) {
        return LongEntity.from(feature, minimum, maximum, featureDistribution, false);
    }

    @ValueRangeProvider(id="longRange")
    public ValueRange<Long> getValueRange() {
        return ValueRangeFactory.createLongValueRange((long)((Long)this.rangeMinimum), (long)((Long)this.rangeMaximum));
    }

    @PlanningVariable(valueRangeProviderRefs={"longRange"})
    public Long getProposedValue() {
        return (Long)this.proposedValue;
    }

    public void setProposedValue(Long proposedValue) {
        this.proposedValue = proposedValue;
    }
}

