/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.Objects;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.EncodingParams;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.PredictionInputsDataDistribution;

public class LimeConfig {
    private static final int DEFAULT_NO_OF_SAMPLES = 300;
    private static final double DEFAULT_SEPARABLE_DATASET_RATIO = 0.9;
    public static final int DEFAULT_NO_OF_RETRIES = 3;
    private static final boolean DEFAULT_ADAPT_DATASET_VARIANCE = true;
    private static final boolean DEFAULT_PENALIZE_BALANCE_SPARSE = true;
    private static final boolean DEFAULT_PROXIMITY_FILTER = true;
    private static final double DEFAULT_PROXIMITY_THRESHOLD = 0.83;
    private static final Number DEFAULT_PROXIMITY_FILTERED_DATASET_MIN = 10;
    private static final double DEFAULT_PROXIMITY_KERNEL_WIDTH = 0.5;
    private static final double DEFAULT_ENCODING_CLUSTER_THRESHOLD = 0.07;
    private static final double DEFAULT_ENCODING_GAUSSIAN_FILTER_WIDTH = 0.75;
    private static final boolean DEFAULT_NORMALIZE_WEIGHTS = true;
    private static final boolean DEFAULT_HIGH_SCORE_ZONES = true;
    private static final int DEFAULT_BOOSTRAP_INPUTS = 50;
    private double separableDatasetRatio = 0.9;
    private int noOfSamples = 300;
    private int noOfRetries = 3;
    private PerturbationContext perturbationContext = new PerturbationContext(new SecureRandom(), 1);
    private boolean adaptDatasetVariance = true;
    private DataDistribution dataDistribution = new PredictionInputsDataDistribution(Collections.emptyList());
    private boolean highScoreFeatureZones = true;
    private boolean penalizeBalanceSparse = true;
    private boolean proximityFilter = true;
    private double proximityThreshold = 0.83;
    private Number proximityFilteredDatasetMinimum = DEFAULT_PROXIMITY_FILTERED_DATASET_MIN;
    private double proximityKernelWidth = 0.5;
    private EncodingParams encodingParams = new EncodingParams(0.75, 0.07);
    private boolean normalizeWeights = true;
    private int boostrapInputs = 50;

    public LimeConfig withDataDistribution(DataDistribution dataDistribution) {
        this.dataDistribution = dataDistribution;
        return this;
    }

    public LimeConfig withSeparableDatasetRatio(double separableDatasetRatio) {
        this.separableDatasetRatio = separableDatasetRatio;
        return this;
    }

    public LimeConfig withPerturbationContext(PerturbationContext perturbationContext) {
        this.perturbationContext = perturbationContext;
        return this;
    }

    public LimeConfig withAdaptiveVariance(boolean adaptDatasetVariance) {
        this.adaptDatasetVariance = adaptDatasetVariance;
        return this;
    }

    public LimeConfig withPenalizeBalanceSparse(boolean penalizeBalanceSparse) {
        this.penalizeBalanceSparse = penalizeBalanceSparse;
        return this;
    }

    public LimeConfig withRetries(int noOfRetries) {
        this.noOfRetries = noOfRetries;
        return this;
    }

    public LimeConfig withSamples(int noOfSamples) {
        this.noOfSamples = noOfSamples;
        return this;
    }

    public LimeConfig withProximityFilter(boolean proximityFilter) {
        this.proximityFilter = proximityFilter;
        return this;
    }

    public LimeConfig withProximityThreshold(double proximityThreshold) {
        this.proximityThreshold = proximityThreshold;
        return this;
    }

    public LimeConfig withProximityKernelWidth(double proximityKernelWidth) {
        this.proximityKernelWidth = proximityKernelWidth;
        return this;
    }

    public int getNoOfRetries() {
        return this.noOfRetries;
    }

    public int getNoOfSamples() {
        return this.noOfSamples;
    }

    public PerturbationContext getPerturbationContext() {
        return this.perturbationContext;
    }

    public boolean isAdaptDatasetVariance() {
        return this.adaptDatasetVariance;
    }

    public double getSeparableDatasetRatio() {
        return this.separableDatasetRatio;
    }

    public boolean isPenalizeBalanceSparse() {
        return this.penalizeBalanceSparse;
    }

    public boolean isProximityFilter() {
        return this.proximityFilter;
    }

    public double getProximityThreshold() {
        return this.proximityThreshold;
    }

    public Number getProximityFilteredDatasetMinimum() {
        return this.proximityFilteredDatasetMinimum;
    }

    public LimeConfig withProximityFilteredDatasetMinimum(Number proximityFilteredDatasetMinimum) {
        this.proximityFilteredDatasetMinimum = proximityFilteredDatasetMinimum;
        return this;
    }

    public double getProximityKernelWidth() {
        return this.proximityKernelWidth;
    }

    public EncodingParams getEncodingParams() {
        return this.encodingParams;
    }

    public LimeConfig withEncodingParams(EncodingParams encodingParams) {
        this.encodingParams = encodingParams;
        return this;
    }

    public LimeConfig withNormalizeWeights(boolean normalizeWeights) {
        this.normalizeWeights = normalizeWeights;
        return this;
    }

    public boolean isNormalizeWeights() {
        return this.normalizeWeights;
    }

    public DataDistribution getDataDistribution() {
        return this.dataDistribution;
    }

    public LimeConfig withHighScoreFeatureZones(boolean highScoreFeatureZones) {
        this.highScoreFeatureZones = highScoreFeatureZones;
        return this;
    }

    public int getBoostrapInputs() {
        return this.boostrapInputs;
    }

    public boolean isHighScoreFeatureZones() {
        return this.highScoreFeatureZones;
    }

    public LimeConfig witBootstrapInputs(int boostrapInputs) {
        this.boostrapInputs = boostrapInputs;
        return this;
    }

    public LimeConfig copy() {
        return new LimeConfig().withSeparableDatasetRatio(this.separableDatasetRatio).withSamples(this.noOfSamples).withRetries(this.noOfRetries).withPerturbationContext(this.perturbationContext).withAdaptiveVariance(this.adaptDatasetVariance).withDataDistribution(this.dataDistribution).withPenalizeBalanceSparse(this.penalizeBalanceSparse).withProximityFilter(this.proximityFilter).withProximityThreshold(this.proximityThreshold).withProximityFilteredDatasetMinimum(this.proximityFilteredDatasetMinimum).withProximityKernelWidth(this.proximityKernelWidth).withEncodingParams(this.encodingParams).withNormalizeWeights(this.normalizeWeights);
    }

    public String toString() {
        return "LimeConfig{separableDatasetRatio=" + this.separableDatasetRatio + ", noOfSamples=" + this.noOfSamples + ", noOfRetries=" + this.noOfRetries + ", perturbationContext=" + this.perturbationContext + ", adaptDatasetVariance=" + this.adaptDatasetVariance + ", dataDistribution=" + this.dataDistribution + ", penalizeBalanceSparse=" + this.penalizeBalanceSparse + ", proximityFilter=" + this.proximityFilter + ", proximityThreshold=" + this.proximityThreshold + ", proximityFilteredDatasetMinimum=" + this.proximityFilteredDatasetMinimum + ", proximityKernelWidth=" + this.proximityKernelWidth + ", encodingParams=" + this.encodingParams + ", normalizeWeights=" + this.normalizeWeights + ", highScoreFeatureZones=" + this.highScoreFeatureZones + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimeConfig that = (LimeConfig)o;
        return Double.compare(that.separableDatasetRatio, this.separableDatasetRatio) == 0 && this.noOfSamples == that.noOfSamples && this.noOfRetries == that.noOfRetries && this.adaptDatasetVariance == that.adaptDatasetVariance && this.highScoreFeatureZones == that.highScoreFeatureZones && this.penalizeBalanceSparse == that.penalizeBalanceSparse && this.proximityFilter == that.proximityFilter && Double.compare(that.proximityThreshold, this.proximityThreshold) == 0 && Double.compare(that.proximityKernelWidth, this.proximityKernelWidth) == 0 && this.normalizeWeights == that.normalizeWeights && this.boostrapInputs == that.boostrapInputs && Objects.equals(this.perturbationContext, that.perturbationContext) && Objects.equals(this.dataDistribution, that.dataDistribution) && Objects.equals(this.proximityFilteredDatasetMinimum, that.proximityFilteredDatasetMinimum) && Objects.equals(this.encodingParams, that.encodingParams);
    }

    public int hashCode() {
        return Objects.hash(this.separableDatasetRatio, this.noOfSamples, this.noOfRetries, this.perturbationContext, this.adaptDatasetVariance, this.dataDistribution, this.highScoreFeatureZones, this.penalizeBalanceSparse, this.proximityFilter, this.proximityThreshold, this.proximityFilteredDatasetMinimum, this.proximityKernelWidth, this.encodingParams, this.normalizeWeights, this.boostrapInputs);
    }
}

