/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.SimplePrediction;

public class Dataset {
    private final List<Prediction> data;

    public Dataset(List<Prediction> data) {
        this.data = data;
    }

    public List<Prediction> getData() {
        return this.data;
    }

    public List<PredictionInput> getInputs() {
        return this.data.stream().map(Prediction::getInput).collect(Collectors.toList());
    }

    public List<PredictionOutput> getOutputs() {
        return this.data.stream().map(Prediction::getOutput).collect(Collectors.toList());
    }

    public Dataset filterByFeature(Predicate<Feature> featureSelector) {
        List inputs = this.data.stream().map(prediction -> prediction.getInput().getFeatures()).map(features -> new PredictionInput(features.stream().filter(featureSelector).collect(Collectors.toList()))).collect(Collectors.toList());
        return new Dataset(IntStream.range(0, this.data.size()).mapToObj(i -> new SimplePrediction((PredictionInput)inputs.get(i), this.data.get(i).getOutput())).collect(Collectors.toList()));
    }

    public Dataset filterByInput(Predicate<PredictionInput> inputSelector) {
        return new Dataset(this.data.stream().filter(p -> inputSelector.test(p.getInput())).collect(Collectors.toList()));
    }

    public Dataset filterByOutput(Predicate<PredictionOutput> outputSelector) {
        return new Dataset(this.data.stream().filter(p -> outputSelector.test(p.getOutput())).collect(Collectors.toList()));
    }
}

