/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Objects;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;

public class Feature {
    private final String name;
    private final Type type;
    private final Value value;
    private final FeatureDomain domain;
    private final boolean constrained;
    private final FeatureDistribution distribution;

    public Feature(String name, Type type, Value value) {
        this(name, type, value, true, EmptyFeatureDomain.create());
    }

    public Feature(String name, Type type, Value value, boolean constrained, FeatureDomain domain) {
        this(name, type, value, constrained, domain, null);
    }

    public Feature(String name, Type type, Value value, boolean constrained, FeatureDomain domain, FeatureDistribution distribution) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.domain = domain;
        this.constrained = constrained;
        this.distribution = distribution;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Value getValue() {
        return this.value;
    }

    public String toString() {
        return "Feature{name='" + this.name + "', type=" + this.type + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        return Objects.equals(this.name, feature.name) && this.type == feature.type && Objects.equals(this.value, feature.value);
    }

    public FeatureDomain getDomain() {
        return this.domain;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public FeatureDistribution getDistribution() {
        return this.distribution;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.value});
    }
}

