/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.NumericFeatureDistribution;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;
import org.kie.kogito.explainability.utils.CompositeFeatureUtils;

class CompositeEntityTest {
    CompositeEntityTest() {
    }

    private static Feature generateCompositeFeature() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newNumericalFeature((String)"f1", (Number)10.0));
        features.add(FeatureFactory.newNumericalFeature((String)"f2", (Number)11.2));
        features.add(FeatureFactory.newNumericalFeature((String)"f3", (Number)5));
        features.add(FeatureFactory.newBooleanFeature((String)"f4", (Boolean)true));
        features.add(FeatureFactory.newBooleanFeature((String)"f5", (Boolean)false));
        HashMap<String, Feature> nestedMap = new HashMap<String, Feature>();
        nestedMap.put("nf-1", FeatureFactory.newNumericalFeature((String)"nff-1", (Number)101.1));
        nestedMap.put("nf-2", FeatureFactory.newNumericalFeature((String)"nff-2", (Number)15.0));
        features.add(FeatureFactory.newCompositeFeature((String)"f7", nestedMap));
        for (Feature f : features) {
            map.put(f.getName(), f.getValue().getUnderlyingObject());
        }
        Feature feature = FeatureFactory.newCompositeFeature((String)"some-name", map);
        return feature;
    }

    @Test
    void testBasicSerDe() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        Feature compositeFeature = CompositeEntityTest.generateCompositeFeature();
        features.add(compositeFeature);
        List flattened = CompositeFeatureUtils.flattenFeatures(features);
        List delinearised = CompositeFeatureUtils.unflattenFeatures((List)flattened, features);
        Assertions.assertEquals(features, (Object)delinearised);
    }

    @Test
    void distanceUnscaled() {
        FeatureDomain featureDomain = NumericalFeatureDomain.create((double)0.0, (double)40.0);
        Feature doubleFeature = FeatureFactory.newNumericalFeature((String)"feature-double", (Number)20.0, (FeatureDomain)featureDomain);
        DoubleEntity entity = (DoubleEntity)CounterfactualEntityFactory.from((Feature)doubleFeature);
        entity.proposedValue = 30.0;
        Assertions.assertEquals((double)10.0, (double)entity.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void distanceScaled(int seed) {
        Random random = new Random();
        random.setSeed(seed);
        Feature doubleFeature = FeatureFactory.newNumericalFeature((String)"feature-double", (Number)20.0, (FeatureDomain)NumericalFeatureDomain.create((double)0.0, (double)40.0));
        NumericFeatureDistribution featureDistribution = new NumericFeatureDistribution(doubleFeature, random.doubles(5000L, 10.0, 40.0).toArray());
        DoubleEntity entity = (DoubleEntity)CounterfactualEntityFactory.from((Feature)doubleFeature, (FeatureDistribution)featureDistribution);
        entity.proposedValue = 30.0;
        double distance = entity.distance();
        Assertions.assertTrue((distance > 0.1 && distance < 0.2 ? 1 : 0) != 0);
    }
}

