/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.shap;

import java.util.ArrayList;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealVector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.local.shap.ShapResults;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureImportance;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

class ShapResultsTest {
    ShapResultsTest() {
    }

    ShapResults buildShapResults(int nOutputs, int nFeatures, int scalar1, int scalar2) {
        Saliency[] saliencies = new Saliency[nOutputs];
        for (int i = 0; i < nOutputs; ++i) {
            ArrayList<FeatureImportance> fis = new ArrayList<FeatureImportance>();
            for (int j = 0; j < nFeatures; ++j) {
                fis.add(new FeatureImportance(new Feature("f" + String.valueOf(j), Type.NUMBER, new Value((Object)j)), (double)(i * j * scalar1)));
            }
            saliencies[i] = new Saliency(new Output("o" + String.valueOf(i), Type.NUMBER, new Value((Object)i), 1.0), fis);
        }
        RealVector fnull = MatrixUtils.createRealVector((double[])new double[nOutputs]);
        fnull.mapAddToSelf((double)scalar2);
        return new ShapResults(saliencies, fnull);
    }

    @Test
    void testEqualsSameObj() {
        ShapResults sr1 = this.buildShapResults(2, 2, 1, 1);
        Assertions.assertEquals((Object)sr1, (Object)sr1);
        Assertions.assertEquals((int)sr1.hashCode(), (int)sr1.hashCode());
    }

    @Test
    void testEquals() {
        ShapResults sr1 = this.buildShapResults(2, 2, 1, 1);
        ShapResults sr2 = this.buildShapResults(2, 2, 1, 1);
        Assertions.assertEquals((Object)sr1, (Object)sr2);
        Assertions.assertNotEquals((int)sr1.hashCode(), (int)sr2.hashCode());
    }

    @Test
    void testDiffOutputs() {
        ShapResults sr1 = this.buildShapResults(2, 2, 1, 1);
        ShapResults sr2 = this.buildShapResults(20, 2, 1, 1);
        Assertions.assertNotEquals((Object)sr1, (Object)sr2);
        Assertions.assertNotEquals((int)sr1.hashCode(), (int)sr2.hashCode());
    }

    @Test
    void testDiffFeatures() {
        ShapResults sr1 = this.buildShapResults(2, 2, 1, 1);
        ShapResults sr2 = this.buildShapResults(2, 20, 1, 1);
        Assertions.assertNotEquals((Object)sr1, (Object)sr2);
        Assertions.assertNotEquals((int)sr1.hashCode(), (int)sr2.hashCode());
    }

    @Test
    void testDiffImportances() {
        ShapResults sr1 = this.buildShapResults(2, 2, 1, 1);
        ShapResults sr2 = this.buildShapResults(2, 2, 10, 1);
        Assertions.assertNotEquals((Object)sr1, (Object)sr2);
        Assertions.assertNotEquals((int)sr1.hashCode(), (int)sr2.hashCode());
    }

    @Test
    void testDiffFnull() {
        ShapResults sr1 = this.buildShapResults(2, 2, 1, 1);
        ShapResults sr2 = this.buildShapResults(2, 2, 1, 10);
        Assertions.assertNotEquals((Object)sr1, (Object)sr2);
        Assertions.assertNotEquals((int)sr1.hashCode(), (int)sr2.hashCode());
    }

    @Test
    void testToString() {
        ShapResults sr = this.buildShapResults(2, 10, 1, 1);
        String srs = sr.toString(2);
        Assertions.assertTrue((boolean)true);
    }
}

