/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.model.Dataset;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.SimplePrediction;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;
import org.kie.kogito.explainability.utils.FairnessMetrics;

class FairnessMetricsTest {
    FairnessMetricsTest() {
    }

    @Test
    void testIndividualConsistencyTextClassifier() throws ExecutionException, InterruptedException {
        BiFunction<PredictionInput, List, List> proximityFunction = (predictionInput, predictionInputs) -> {
            String reference = DataUtils.textify((PredictionInput)predictionInput);
            return predictionInputs.stream().sorted((o1, o2) -> StringUtils.getFuzzyDistance((CharSequence)DataUtils.textify((PredictionInput)o2), (CharSequence)reference, (Locale)Locale.getDefault()) - StringUtils.getFuzzyDistance((CharSequence)DataUtils.textify((PredictionInput)o1), (CharSequence)reference, (Locale)Locale.getDefault())).collect(Collectors.toList()).subList(1, 3);
        };
        List<PredictionInput> testInputs = this.getTestInputs();
        PredictionProvider model = TestUtils.getDummyTextClassifier();
        double individualConsistency = FairnessMetrics.individualConsistency(proximityFunction, testInputs, (PredictionProvider)model);
        AssertionsForClassTypes.assertThat((double)individualConsistency).isBetween(Double.valueOf(0.0), Double.valueOf(1.0));
    }

    @Test
    void testGroupSPDTextClassifier() throws ExecutionException, InterruptedException {
        List<PredictionInput> testInputs = this.getTestInputs();
        PredictionProvider model = TestUtils.getDummyTextClassifier();
        Predicate<PredictionInput> selector = predictionInput -> DataUtils.textify((PredictionInput)predictionInput).contains("please");
        Output output = new Output("spam", Type.BOOLEAN, new Value((Object)false), 1.0);
        double spd = FairnessMetrics.groupStatisticalParityDifference(selector, testInputs, (PredictionProvider)model, (Output)output);
        AssertionsForClassTypes.assertThat((double)spd).isBetween(Double.valueOf(-1.0), Double.valueOf(1.0));
    }

    @Test
    void testGroupDIRTextClassifier() throws ExecutionException, InterruptedException {
        List<PredictionInput> testInputs = this.getTestInputs();
        PredictionProvider model = TestUtils.getDummyTextClassifier();
        Predicate<PredictionInput> selector = predictionInput -> DataUtils.textify((PredictionInput)predictionInput).contains("please");
        Output output = new Output("spam", Type.BOOLEAN, new Value((Object)false), 1.0);
        double dir = FairnessMetrics.groupDisparateImpactRatio(selector, testInputs, (PredictionProvider)model, (Output)output);
        AssertionsForClassTypes.assertThat((double)dir).isPositive();
    }

    @Test
    void testGroupAODTextClassifier() throws ExecutionException, InterruptedException {
        List<Prediction> predictions = this.getTestData();
        Dataset dataset = new Dataset(predictions);
        PredictionProvider model = TestUtils.getDummyTextClassifier();
        Predicate<PredictionInput> inputSelector = predictionInput -> DataUtils.textify((PredictionInput)predictionInput).contains("please");
        Predicate<PredictionOutput> outputSelector = predictionOutput -> ((Output)predictionOutput.getByName("spam").get()).getValue().asNumber() == 0.0;
        double aod = FairnessMetrics.groupAverageOddsDifference(inputSelector, outputSelector, (Dataset)dataset, (PredictionProvider)model);
        AssertionsForClassTypes.assertThat((double)aod).isBetween(Double.valueOf(-1.0), Double.valueOf(1.0));
    }

    @Test
    void testGroupAPVDTextClassifier() throws ExecutionException, InterruptedException {
        List<Prediction> predictions = this.getTestData();
        Dataset dataset = new Dataset(predictions);
        PredictionProvider model = TestUtils.getDummyTextClassifier();
        Predicate<PredictionInput> inputSelector = predictionInput -> DataUtils.textify((PredictionInput)predictionInput).contains("please");
        Predicate<PredictionOutput> outputSelector = predictionOutput -> ((Output)predictionOutput.getByName("spam").get()).getValue().asNumber() == 0.0;
        double apvd = FairnessMetrics.groupAveragePredictiveValueDifference(inputSelector, outputSelector, (Dataset)dataset, (PredictionProvider)model);
        AssertionsForClassTypes.assertThat((double)apvd).isBetween(Double.valueOf(-1.0), Double.valueOf(1.0));
    }

    private List<PredictionInput> getTestInputs() {
        ArrayList<PredictionInput> inputs = new ArrayList<PredictionInput>();
        Function<String, List> tokenizer = s -> Arrays.asList((String[])s.split(" ").clone());
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"urgent inquiry", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"please give me some money", tokenizer));
        inputs.add(new PredictionInput(features));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"please reply", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"we got urgent matter! please reply", tokenizer));
        inputs.add(new PredictionInput(features));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"please reply", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"we got money matter! please reply", tokenizer));
        inputs.add(new PredictionInput(features));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"inquiry", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"would you like to get a 100% secure way to invest your money?", tokenizer));
        inputs.add(new PredictionInput(features));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"you win", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"you just won an incredible 1M $ prize !", tokenizer));
        inputs.add(new PredictionInput(features));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"prize waiting", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"you are the lucky winner of a 100k $ prize", tokenizer));
        inputs.add(new PredictionInput(features));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"urgent matter", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"we got an urgent inquiry for you to answer.", tokenizer));
        inputs.add(new PredictionInput(features));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"password change", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"you just requested to change your password", tokenizer));
        inputs.add(new PredictionInput(features));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"password stolen", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"we stole your password, if you want it back, send some money .", tokenizer));
        inputs.add(new PredictionInput(features));
        return inputs;
    }

    private List<Prediction> getTestData() {
        ArrayList<Prediction> data = new ArrayList<Prediction>();
        Function<String, List> tokenizer = s -> Arrays.asList((String[])s.split(" ").clone());
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"urgent inquiry", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"please give me some money", tokenizer));
        Output output = new Output("spam", Type.BOOLEAN, new Value((Object)true), 1.0);
        data.add((Prediction)new SimplePrediction(new PredictionInput(features), new PredictionOutput(List.of(output))));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"do not reply", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"if you asked to reset your password, ignore this", tokenizer));
        output = new Output("spam", Type.BOOLEAN, new Value((Object)false), 1.0);
        data.add((Prediction)new SimplePrediction(new PredictionInput(features), new PredictionOutput(List.of(output))));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"please reply", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"we got money matter! please reply", tokenizer));
        output = new Output("spam", Type.BOOLEAN, new Value((Object)true), 1.0);
        data.add((Prediction)new SimplePrediction(new PredictionInput(features), new PredictionOutput(List.of(output))));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"inquiry", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"would you like to get a 100% secure way to invest your money?", tokenizer));
        output = new Output("spam", Type.BOOLEAN, new Value((Object)true), 1.0);
        data.add((Prediction)new SimplePrediction(new PredictionInput(features), new PredictionOutput(List.of(output))));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"clear some space", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"you just finished your space, upgrade today for 1 $ a week", tokenizer));
        output = new Output("spam", Type.BOOLEAN, new Value((Object)false), 1.0);
        data.add((Prediction)new SimplePrediction(new PredictionInput(features), new PredictionOutput(List.of(output))));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"prize waiting", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"you are the lucky winner of a 100k $ prize", tokenizer));
        output = new Output("spam", Type.BOOLEAN, new Value((Object)true), 1.0);
        data.add((Prediction)new SimplePrediction(new PredictionInput(features), new PredictionOutput(List.of(output))));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"urgent matter", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"we got an urgent inquiry for you to answer.", tokenizer));
        output = new Output("spam", Type.BOOLEAN, new Value((Object)true), 1.0);
        data.add((Prediction)new SimplePrediction(new PredictionInput(features), new PredictionOutput(List.of(output))));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"password change", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"you just requested to change your password", tokenizer));
        output = new Output("spam", Type.BOOLEAN, new Value((Object)false), 1.0);
        data.add((Prediction)new SimplePrediction(new PredictionInput(features), new PredictionOutput(List.of(output))));
        features = new ArrayList();
        features.add(FeatureFactory.newFulltextFeature((String)"subject", (String)"password stolen", tokenizer));
        features.add(FeatureFactory.newFulltextFeature((String)"text", (String)"we stole your password, if you want it back, send some money .", tokenizer));
        output = new Output("spam", Type.BOOLEAN, new Value((Object)true), 1.0);
        data.add((Prediction)new SimplePrediction(new PredictionInput(features), new PredictionOutput(List.of(output))));
        return data;
    }
}

