/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.OneHotter;

class OneHotterTest {
    OneHotterTest() {
    }

    @Test
    void CollisionTest() {
        List<Value> fruits = List.of(new Value((Object)"avocado_"), new Value((Object)"banana"), new Value((Object)"carrot"), new Value((Object)"dragonfruit"), new Value((Object)""));
        Random rn = new Random(101L);
        ArrayList<PredictionInput> data = new ArrayList<PredictionInput>();
        for (int i = 0; i < 101; ++i) {
            ArrayList<Feature> fs = new ArrayList<Feature>();
            for (int j = 0; j < 8; ++j) {
                fs.add(new Feature(String.format("Fruit _OHE_ %d", j), Type.CATEGORICAL, fruits.get(rn.nextInt(5))));
            }
            data.add(new PredictionInput(fs));
        }
        PerturbationContext pc = new PerturbationContext(new Random(), 0);
        OneHotter oh = new OneHotter(data, pc);
        Assertions.assertTrue((boolean)true);
    }

    @Test
    void CollisionProxyTest() {
        List<Value> fruits = List.of(new Value((Object)"avocado_"), new Value((Object)"banana"), new Value((Object)"carrot"), new Value((Object)"dragonfruit"), new Value((Object)""));
        Random rn = new Random(101L);
        ArrayList<PredictionInput> data = new ArrayList<PredictionInput>();
        for (int i = 0; i < 101; ++i) {
            ArrayList<Feature> fs = new ArrayList<Feature>();
            for (int j = 0; j < 8; ++j) {
                fs.add(new Feature(String.format("Fruit _OHEPROXY %d", j), Type.CATEGORICAL, fruits.get(rn.nextInt(5))));
            }
            data.add(new PredictionInput(fs));
        }
        PerturbationContext pc = new PerturbationContext(new Random(), 0);
        OneHotter oh = new OneHotter(data, pc);
        Assertions.assertTrue((boolean)true);
    }

    @Test
    void MixedFeatureTest() {
        List<Value> fruits = List.of(new Value((Object)"avocado_"), new Value((Object)"banana"), new Value((Object)"carrot"), new Value((Object)"dragonfruit"), new Value((Object)""));
        Random rn = new Random(101L);
        ArrayList<PredictionInput> data = new ArrayList<PredictionInput>();
        for (int i = 0; i < 101; ++i) {
            ArrayList<Feature> fs = new ArrayList<Feature>();
            for (int j = 0; j < 8; ++j) {
                fs.add(new Feature(String.format("Fruit %d", j), Type.CATEGORICAL, fruits.get(rn.nextInt(5))));
            }
            fs.add(new Feature("Numeric", Type.NUMBER, new Value((Object)i)));
            data.add(new PredictionInput(fs));
        }
        PerturbationContext pc = new PerturbationContext(new Random(), 0);
        OneHotter oh = new OneHotter(data, pc);
        List encoded = oh.oneHotEncode(data, false);
        List encodedProxy = oh.oneHotEncode(data, true);
        List decoded = oh.oneHotDecode(encoded, false);
        List decodedProxy = oh.oneHotDecode(encodedProxy, true);
        Assertions.assertEquals((Object)decoded, data);
        Assertions.assertEquals((Object)decodedProxy, data);
    }
}

