/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.kogito.explainability.local.counterfactual.entities.BinaryEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CurrencyEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DurationEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.LongEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.ObjectEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.TimeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.URIEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBinaryEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCompositeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCurrencyEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDurationEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedIntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedLongEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedObjectEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedTextEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedTimeEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedURIEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedVectorEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.domain.BinaryFeatureDomain;
import org.kie.kogito.explainability.model.domain.CategoricalFeatureDomain;
import org.kie.kogito.explainability.model.domain.CurrencyFeatureDomain;
import org.kie.kogito.explainability.model.domain.DurationFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.ObjectFeatureDomain;
import org.kie.kogito.explainability.model.domain.URIFeatureDomain;
import org.kie.kogito.explainability.utils.CompositeFeatureUtils;

public class CounterfactualEntityFactory {
    private CounterfactualEntityFactory() {
    }

    public static CounterfactualEntity from(Feature feature) {
        return CounterfactualEntityFactory.from(feature, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CounterfactualEntity from(Feature feature, FeatureDistribution featureDistribution) {
        void var2_28;
        Object var2_2 = null;
        CounterfactualEntityFactory.validateFeature(feature);
        Type type = feature.getType();
        FeatureDomain featureDomain = feature.getDomain();
        boolean isConstrained = feature.isConstrained();
        Object valueObject = feature.getValue().getUnderlyingObject();
        if (type == Type.NUMBER) {
            if (valueObject instanceof Double) {
                if (isConstrained) {
                    FixedDoubleEntity fixedDoubleEntity = FixedDoubleEntity.from(feature);
                    return var2_28;
                } else {
                    DoubleEntity doubleEntity = DoubleEntity.from(feature, featureDomain.getLowerBound(), featureDomain.getUpperBound(), featureDistribution, isConstrained);
                }
                return var2_28;
            } else if (valueObject instanceof Long) {
                if (isConstrained) {
                    FixedLongEntity fixedLongEntity = FixedLongEntity.from(feature);
                    return var2_28;
                } else {
                    LongEntity longEntity = LongEntity.from(feature, featureDomain.getLowerBound().intValue(), featureDomain.getUpperBound().intValue(), featureDistribution, isConstrained);
                }
                return var2_28;
            } else {
                if (!(valueObject instanceof Integer)) return var2_28;
                if (isConstrained) {
                    FixedIntegerEntity fixedIntegerEntity = FixedIntegerEntity.from(feature);
                    return var2_28;
                } else {
                    IntegerEntity integerEntity = IntegerEntity.from(feature, featureDomain.getLowerBound().intValue(), featureDomain.getUpperBound().intValue(), featureDistribution, isConstrained);
                }
            }
            return var2_28;
        } else if (feature.getType() == Type.BOOLEAN) {
            if (isConstrained) {
                FixedBooleanEntity fixedBooleanEntity = FixedBooleanEntity.from(feature);
                return var2_28;
            } else {
                BooleanEntity booleanEntity = BooleanEntity.from(feature, isConstrained);
            }
            return var2_28;
        } else if (feature.getType() == Type.TEXT) {
            if (!isConstrained) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedTextEntity fixedTextEntity = FixedTextEntity.from(feature);
            return var2_28;
        } else if (feature.getType() == Type.BINARY) {
            if (isConstrained) {
                FixedBinaryEntity fixedBinaryEntity = FixedBinaryEntity.from(feature);
                return var2_28;
            } else {
                BinaryEntity binaryEntity = BinaryEntity.from(feature, ((BinaryFeatureDomain)featureDomain).getCategories(), isConstrained);
            }
            return var2_28;
        } else if (feature.getType() == Type.URI) {
            if (isConstrained) {
                FixedURIEntity fixedURIEntity = FixedURIEntity.from(feature);
                return var2_28;
            } else {
                URIEntity uRIEntity = URIEntity.from(feature, ((URIFeatureDomain)featureDomain).getCategories(), isConstrained);
            }
            return var2_28;
        } else if (feature.getType() == Type.TIME) {
            if (isConstrained) {
                FixedTimeEntity fixedTimeEntity = FixedTimeEntity.from(feature);
                return var2_28;
            } else {
                LocalTime lowerBound = LocalTime.MIN.plusSeconds(featureDomain.getLowerBound().longValue());
                LocalTime upperBound = LocalTime.MIN.plusSeconds(featureDomain.getUpperBound().longValue());
                TimeEntity timeEntity = TimeEntity.from(feature, lowerBound, upperBound, isConstrained);
            }
            return var2_28;
        } else if (feature.getType() == Type.DURATION) {
            if (isConstrained) {
                FixedDurationEntity fixedDurationEntity = FixedDurationEntity.from(feature);
                return var2_28;
            } else {
                DurationFeatureDomain domain = (DurationFeatureDomain)featureDomain;
                DurationEntity durationEntity = DurationEntity.from(feature, Duration.of(domain.getLowerBound().longValue(), domain.getUnit()), Duration.of(domain.getUpperBound().longValue(), domain.getUnit()), featureDistribution, isConstrained);
            }
            return var2_28;
        } else if (feature.getType() == Type.VECTOR) {
            if (!isConstrained) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedVectorEntity fixedVectorEntity = FixedVectorEntity.from(feature);
            return var2_28;
        } else if (feature.getType() == Type.COMPOSITE) {
            if (!isConstrained) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            FixedCompositeEntity fixedCompositeEntity = FixedCompositeEntity.from(feature);
            return var2_28;
        } else if (feature.getType() == Type.CURRENCY) {
            if (isConstrained) {
                FixedCurrencyEntity fixedCurrencyEntity = FixedCurrencyEntity.from(feature);
                return var2_28;
            } else {
                CurrencyEntity currencyEntity = CurrencyEntity.from(feature, ((CurrencyFeatureDomain)featureDomain).getCategories(), isConstrained);
            }
            return var2_28;
        } else if (feature.getType() == Type.CATEGORICAL) {
            if (isConstrained) {
                FixedCategoricalEntity fixedCategoricalEntity = FixedCategoricalEntity.from(feature);
                return var2_28;
            } else {
                CategoricalEntity categoricalEntity = CategoricalEntity.from(feature, ((CategoricalFeatureDomain)featureDomain).getCategories(), isConstrained);
            }
            return var2_28;
        } else {
            if (feature.getType() != Type.UNDEFINED) throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
            if (isConstrained) {
                FixedObjectEntity fixedObjectEntity = FixedObjectEntity.from(feature);
                return var2_28;
            } else {
                ObjectEntity objectEntity = ObjectEntity.from(feature, ((ObjectFeatureDomain)featureDomain).getCategories(), isConstrained);
            }
        }
        return var2_28;
    }

    public static void validateFeature(Feature feature) {
        Type type = feature.getType();
        Object object = feature.getValue().getUnderlyingObject();
        if (type == Type.NUMBER && object == null) {
            throw new IllegalArgumentException("Null numeric features are not supported in counterfactuals");
        }
    }

    public static List<CounterfactualEntity> createEntities(PredictionInput predictionInput) {
        List<Feature> linearizedFeatures = CompositeFeatureUtils.flattenFeatures(predictionInput.getFeatures());
        return linearizedFeatures.stream().map(feature -> CounterfactualEntityFactory.from(feature, feature.getDistribution())).collect(Collectors.toList());
    }
}

