/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.Set;
import org.kie.kogito.explainability.local.counterfactual.entities.AbstractCategoricalEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class ObjectEntity
extends AbstractCategoricalEntity<Object> {
    public ObjectEntity() {
    }

    private ObjectEntity(Object originalValue, String featureName, Set<Object> allowedCategories, boolean constrained) {
        super(originalValue, featureName, allowedCategories, constrained);
    }

    public static ObjectEntity from(Feature originalFeature, Set<Object> categories, boolean constrained) {
        return new ObjectEntity(originalFeature.getValue().getUnderlyingObject(), originalFeature.getName(), categories, constrained);
    }

    public static ObjectEntity from(Feature originalFeature, Set<Object> categories) {
        return ObjectEntity.from(originalFeature, categories, false);
    }

    @Override
    @ValueRangeProvider(id="categoricalRange")
    public Set<Object> getValueRange() {
        return this.allowedCategories;
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newObjectFeature(this.featureName, this.proposedValue);
    }

    @Override
    @PlanningVariable(valueRangeProviderRefs={"categoricalRange"})
    public Object getProposedValue() {
        return this.proposedValue;
    }

    @Override
    public void setProposedValue(Object proposedValue) {
        this.proposedValue = proposedValue;
    }
}

