/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigOptimizer;
import org.kie.kogito.explainability.local.lime.optim.LimeOptimizationRequest;
import org.kie.kogito.explainability.local.lime.optim.LimeOptimizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLimeOptimizationService
implements LimeOptimizationService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLimeOptimizationService.class);
    private final Deque<CompletableFuture<Void>> queue;
    private final LinkedHashMap<LimeExplainer, LimeConfig> register;
    private final LimeConfigOptimizer limeConfigOptimizer;
    private final int maxJobsExecuted;

    public DefaultLimeOptimizationService(LimeConfigOptimizer limeConfigOptimizer, final int maxJobsExecuted) {
        this.maxJobsExecuted = maxJobsExecuted;
        this.limeConfigOptimizer = limeConfigOptimizer;
        this.register = new LinkedHashMap<LimeExplainer, LimeConfig>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<LimeExplainer, LimeConfig> eldest) {
                return this.size() > Math.max(10, maxJobsExecuted);
            }
        };
        this.queue = new ConcurrentLinkedDeque<CompletableFuture<Void>>();
    }

    @Override
    public boolean submit(LimeOptimizationRequest limeOptimizationRequest) {
        if (this.queue.size() < this.maxJobsExecuted) {
            CompletionStage completableFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.limeConfigOptimizer.optimize(limeOptimizationRequest.getLimeConfig(), limeOptimizationRequest.getPredictions(), limeOptimizationRequest.getPredictionProvider())).thenAccept(c -> this.register.put(limeOptimizationRequest.getExplainer(), (LimeConfig)c))).thenRun(this.flushQueue());
            logger.info("optimization job submitted");
            return this.queue.offer((CompletableFuture<Void>)completableFuture);
        }
        logger.warn("busy optimizing (queue size: {}), next time!", (Object)this.queue.size());
        return false;
    }

    private Runnable flushQueue() {
        return () -> {
            List finished = this.queue.stream().filter(CompletableFuture::isDone).collect(Collectors.toList());
            for (CompletableFuture f : finished) {
                this.queue.remove(f);
            }
        };
    }

    @Override
    public LimeConfig getBestConfigFor(LimeExplainer limeExplainer) {
        return this.register.get(limeExplainer);
    }
}

