/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.LocalExplanationException;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;

class LimeExplainerTest {
    LimeExplainerTest() {
    }

    @Test
    void testEmptyPrediction() throws ExecutionException, InterruptedException, TimeoutException {
        Random random = new Random();
        for (int seed = 0; seed < 5; ++seed) {
            random.setSeed(seed);
            LimeConfig limeConfig = new LimeConfig().withSamples(10);
            LimeExplainer limeExplainer = new LimeExplainer(limeConfig);
            PredictionInput input = new PredictionInput(Collections.emptyList());
            PredictionProvider model = TestUtils.getSumSkipModel(0);
            PredictionOutput output = (PredictionOutput)((List)model.predictAsync(List.of(input)).get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit())).get(0);
            Prediction prediction = new Prediction(input, output);
            Assertions.assertThrows(LocalExplanationException.class, () -> limeExplainer.explainAsync(prediction, model));
        }
    }

    @Test
    void testNonEmptyInput() throws ExecutionException, InterruptedException, TimeoutException {
        Random random = new Random();
        for (int seed = 0; seed < 5; ++seed) {
            random.setSeed(seed);
            LimeConfig limeConfig = new LimeConfig().withSamples(10);
            LimeExplainer limeExplainer = new LimeExplainer(limeConfig);
            LinkedList<Feature> features = new LinkedList<Feature>();
            for (int i = 0; i < 4; ++i) {
                features.add(TestUtils.getMockedNumericFeature(i));
            }
            PredictionInput input = new PredictionInput(features);
            PredictionProvider model = TestUtils.getSumSkipModel(0);
            PredictionOutput output = (PredictionOutput)((List)model.predictAsync(List.of(input)).get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit())).get(0);
            Prediction prediction = new Prediction(input, output);
            Map saliencyMap = (Map)limeExplainer.explainAsync(prediction, model).get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit());
            Assertions.assertNotNull((Object)saliencyMap);
        }
    }
}

