/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

class TypeTest {
    TypeTest() {
    }

    @Test
    void testPerturbNumericDouble() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)0.1);
        Feature f = new Feature("name", Type.NUMBER, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbNumericInteger() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)1);
        Feature f = new Feature("name", Type.NUMBER, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbSingleTermString() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"foo");
        Feature f = new Feature("name", Type.TEXT, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbMultiTermString() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"foo bar");
        Feature f = new Feature("name", Type.TEXT, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbCategorical() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"1");
        Feature f = new Feature("name", Type.CATEGORICAL, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbBinary() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        ByteBuffer bytes = ByteBuffer.allocate(16);
        bytes.put("foo".getBytes(Charset.defaultCharset()));
        Value value = new Value((Object)bytes);
        Feature f = new Feature("name", Type.BINARY, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbBoolean() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)false);
        Feature f = new Feature("name", Type.BOOLEAN, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbDuration() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)Duration.ofDays(10L));
        Feature f = new Feature("name", Type.DURATION, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbTime() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)LocalTime.of(10, 10));
        Feature f = new Feature("name", Type.TIME, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbURI() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"http://localhost:8080");
        Feature f = new Feature("name", Type.URI, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbNonLocalhostURI() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"http://128.0.0.1:8081");
        Feature f = new Feature("name", Type.URI, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbFragmentURI() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"http://localhost:8080/path#paragraph1");
        Feature f = new Feature("name", Type.URI, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbVector() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        double[] doubles = new double[3];
        Arrays.fill(doubles, 1.0);
        Value value = new Value((Object)doubles);
        Feature f = new Feature("name", Type.VECTOR, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbNestedFeature() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Feature feature = new Feature("name", Type.NUMBER, new Value((Object)1.0));
        Value value = new Value((Object)feature);
        Feature f = new Feature("name", Type.UNDEFINED, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbByteBufferFeature() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        byte[] bytes = new byte[1024];
        perturbationContext.getRandom().nextBytes(bytes);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        byteBuffer.put(bytes);
        Feature feature = new Feature("name", Type.BINARY, new Value((Object)byteBuffer));
        Value perturbedValue = feature.getType().perturb(feature.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)feature.getValue(), (Object)perturbedValue);
    }

    @Test
    void testPerturbURIFeature() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        URI uri = URI.create("https://www.redhat.com/en/technologies/jboss-middleware/process-automation-manager");
        Feature feature = new Feature("name", Type.URI, new Value((Object)uri));
        Value perturbedValue = feature.getType().perturb(feature.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)feature.getValue(), (Object)perturbedValue);
    }

    @Test
    void testPerturbTimeFeature() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        LocalTime time = LocalTime.now();
        Feature feature = new Feature("name", Type.TIME, new Value((Object)time));
        Value perturbedValue = feature.getType().perturb(feature.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)feature.getValue(), (Object)perturbedValue);
    }

    @Test
    void testPerturbDurationFeature() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Duration time = Duration.of(2L, ChronoUnit.DAYS);
        Feature feature = new Feature("name", Type.DURATION, new Value((Object)time));
        Value perturbedValue = feature.getType().perturb(feature.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)feature.getValue(), (Object)perturbedValue);
    }

    @Test
    void testZeroCategory() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        String category = "0";
        Feature feature = new Feature("name", Type.CATEGORICAL, new Value((Object)category));
        Value perturbedValue = feature.getType().perturb(feature.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)feature.getValue(), (Object)perturbedValue);
    }

    @Test
    void testNonZeroCategory() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        String category = "1";
        Feature feature = new Feature("name", Type.CATEGORICAL, new Value((Object)category));
        Value perturbedValue = feature.getType().perturb(feature.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)feature.getValue(), (Object)perturbedValue);
    }

    @Test
    void testPerturbCurrencyFeature() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Currency currency = Currency.getInstance(Locale.ITALY);
        Feature feature = new Feature("name", Type.CURRENCY, new Value((Object)currency));
        Value perturbedValue = feature.getType().perturb(feature.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)feature.getValue(), (Object)perturbedValue);
    }

    @Test
    void testPerturbCompositeFeature() {
        Random random = new Random();
        for (int i = 0; i < 10000; ++i) {
            random.setSeed(i);
            PerturbationContext perturbationContext = new PerturbationContext(random, 2);
            LinkedList<Feature> features = new LinkedList<Feature>();
            features.add(new Feature("f1", Type.TEXT, new Value((Object)"foo bar")));
            features.add(new Feature("f2", Type.NUMBER, new Value((Object)1.0)));
            features.add(new Feature("f3", Type.BOOLEAN, new Value((Object)true)));
            Value value = new Value(features);
            Feature f = new Feature("name", Type.COMPOSITE, value);
            Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue, (String)("fail with seed " + i));
        }
    }

    @Test
    void testPerturbCompositeFeatureTooManyPerturbations() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1000);
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(new Feature("f1", Type.TEXT, new Value((Object)"foo bar")));
        features.add(new Feature("f2", Type.NUMBER, new Value((Object)1.0)));
        Value value = new Value(features);
        Feature f = new Feature("name", Type.COMPOSITE, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @ParameterizedTest
    @EnumSource
    void testDrop(Type type) {
        Value v = new Value((Object)1.0);
        Value dropped = type.drop(v);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)v, (Object)dropped);
    }

    @ParameterizedTest
    @EnumSource
    void testPerturb(Type type) {
        for (int seed = 0; seed < 5; ++seed) {
            Value v = new Value((Object)1.0);
            Random random = new Random();
            random.setSeed(seed);
            PerturbationContext perturbationContext = new PerturbationContext(random, 1);
            Value perturbed = type.perturb(v, perturbationContext);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)v, (Object)perturbed, (String)type.name());
        }
    }

    @ParameterizedTest
    @EnumSource
    void testEncode(Type type) {
        for (int seed = 0; seed < 5; ++seed) {
            Random random = new Random();
            random.setSeed(seed);
            PerturbationContext perturbationContext = new PerturbationContext(random, random.nextInt());
            Value target = type.randomValue(perturbationContext);
            Value[] values = new Value[random.nextInt(10)];
            for (int i = 0; i < values.length; ++i) {
                values[i] = type.randomValue(perturbationContext);
            }
            List vectors = type.encode(target, values);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)vectors);
            org.junit.jupiter.api.Assertions.assertEquals((int)values.length, (int)vectors.size());
            for (double[] vector : vectors) {
                Assertions.assertThat((double)Arrays.stream(vector).min().orElse(-2.0)).isGreaterThanOrEqualTo(-1.0);
                Assertions.assertThat((double)Arrays.stream(vector).max().orElse(2.0)).isLessThanOrEqualTo(1.0);
            }
        }
    }

    @Test
    void testEncodeNumericSymmetric() {
        for (int seed = 0; seed < 5; ++seed) {
            Random random = new Random();
            random.setSeed(seed);
            PerturbationContext perturbationContext = new PerturbationContext(random, random.nextInt());
            Value target = Type.NUMBER.randomValue(perturbationContext);
            Value[] values = new Value[6];
            for (int i = 0; i < values.length / 2; ++i) {
                values[i] = new Value((Object)(target.asNumber() + target.asNumber() * (double)(1 + i) / 100.0));
                values[values.length - 1 - i] = new Value((Object)(target.asNumber() - target.asNumber() * (double)(1 + i) / 100.0));
            }
            List vectors = Type.NUMBER.encode(target, values);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)vectors);
            org.junit.jupiter.api.Assertions.assertEquals((int)values.length, (int)vectors.size());
            for (int i = 0; i < vectors.size() / 2; ++i) {
                Assertions.assertThat((double)((double[])vectors.get(i))[0]).isEqualTo(((double[])vectors.get(vectors.size() - 1 - i))[0]);
            }
        }
    }

    @Test
    void testEncodeNaN() {
        Random random = new Random();
        random.setSeed(4L);
        PerturbationContext perturbationContext = new PerturbationContext(random, 1);
        Value target = Type.NUMBER.randomValue(perturbationContext);
        Value[] values = new Value[6];
        for (int i = 0; i < values.length - 1; ++i) {
            values[i] = Type.NUMBER.randomValue(perturbationContext);
        }
        values[5] = new Value((Object)Double.NaN);
        List vectors = Type.NUMBER.encode(target, values);
        Assertions.assertThat((List)vectors).isNotEmpty();
        Assertions.assertThat((List)vectors).doesNotContain((Object[])new double[][]{{Double.NaN}});
    }

    @ParameterizedTest
    @EnumSource
    void testRandomValue(Type type) {
        for (int seed = 0; seed < 5; ++seed) {
            Random random = new Random();
            random.setSeed(seed);
            PerturbationContext perturbationContext = new PerturbationContext(random, random.nextInt());
            Value value = type.randomValue(perturbationContext);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)value);
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> type.drop(value));
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> type.perturb(value, perturbationContext));
        }
    }
}

