/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.security.SecureRandom;
import org.kie.kogito.explainability.model.PerturbationContext;

public class LimeConfig {
    private static final int DEFAULT_NO_OF_SAMPLES = 300;
    private static final double DEFAULT_SEPARABLE_DATASET_RATIO = 0.99;
    public static final int DEFAULT_NO_OF_RETRIES = 3;
    private static final boolean DEFAULT_ADAPT_DATASET_VARIANCE = false;
    private double separableDatasetRatio = 0.99;
    private int noOfSamples = 300;
    private int noOfRetries = 3;
    private PerturbationContext perturbationContext = new PerturbationContext(new SecureRandom(), 1);
    private boolean adaptDatasetVariance = false;

    public LimeConfig withSeparableDatasetRatio(double separableDatasetRatio) {
        this.separableDatasetRatio = separableDatasetRatio;
        return this;
    }

    public LimeConfig withPerturbationContext(PerturbationContext perturbationContext) {
        this.perturbationContext = perturbationContext;
        return this;
    }

    public LimeConfig withAdaptiveVariance(boolean adaptDatasetVariance) {
        this.adaptDatasetVariance = adaptDatasetVariance;
        return this;
    }

    public LimeConfig withRetries(int noOfRetries) {
        this.noOfRetries = noOfRetries;
        return this;
    }

    public LimeConfig withSamples(int noOfSamples) {
        this.noOfSamples = noOfSamples;
        return this;
    }

    public int getNoOfRetries() {
        return this.noOfRetries;
    }

    public int getNoOfSamples() {
        return this.noOfSamples;
    }

    public PerturbationContext getPerturbationContext() {
        return this.perturbationContext;
    }

    public boolean adaptDatasetVariance() {
        return this.adaptDatasetVariance;
    }

    public double getSeparableDatasetRatio() {
        return this.separableDatasetRatio;
    }
}

